/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models.OriginGroupUpdatePropertiesParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.OriginGroupProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.OriginGroupResourceState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import java.io.IOException;
import java.util.List;

public final class OriginGroupProperties
extends OriginGroupUpdatePropertiesParameters {
    private OriginGroupResourceState resourceState;
    private OriginGroupProvisioningState provisioningState;

    public OriginGroupResourceState resourceState() {
        return this.resourceState;
    }

    public OriginGroupProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public OriginGroupProperties withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        super.withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    @Override
    public OriginGroupProperties withOrigins(List<ResourceReference> origins) {
        super.withOrigins(origins);
        return this;
    }

    @Override
    public OriginGroupProperties withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        super.withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        return this;
    }

    @Override
    public OriginGroupProperties withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        super.withResponseBasedOriginErrorDetectionSettings(responseBasedOriginErrorDetectionSettings);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("healthProbeSettings", this.healthProbeSettings());
        jsonWriter.writeArrayField("origins", this.origins(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("trafficRestorationTimeToHealedOrNewEndpointsInMinutes", this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes());
        jsonWriter.writeJsonField("responseBasedOriginErrorDetectionSettings", this.responseBasedOriginErrorDetectionSettings());
        return jsonWriter.writeEndObject();
    }

    public static OriginGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OriginGroupProperties deserializedOriginGroupProperties = new OriginGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthProbeSettings".equals(fieldName)) {
                    deserializedOriginGroupProperties.withHealthProbeSettings(HealthProbeParameters.fromJson(reader));
                    continue;
                }
                if ("origins".equals(fieldName)) {
                    List<ResourceReference> origins = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedOriginGroupProperties.withOrigins((List)origins);
                    continue;
                }
                if ("trafficRestorationTimeToHealedOrNewEndpointsInMinutes".equals(fieldName)) {
                    deserializedOriginGroupProperties.withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("responseBasedOriginErrorDetectionSettings".equals(fieldName)) {
                    deserializedOriginGroupProperties.withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters.fromJson(reader));
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedOriginGroupProperties.resourceState = OriginGroupResourceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOriginGroupProperties.provisioningState = OriginGroupProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOriginGroupProperties;
        });
    }
}

