/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import java.io.IOException;
import java.util.List;

public class OriginGroupUpdatePropertiesParameters
implements JsonSerializable<OriginGroupUpdatePropertiesParameters> {
    private HealthProbeParameters healthProbeSettings;
    private List<ResourceReference> origins;
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    private ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings;

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public OriginGroupUpdatePropertiesParameters withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public List<ResourceReference> origins() {
        return this.origins;
    }

    public OriginGroupUpdatePropertiesParameters withOrigins(List<ResourceReference> origins) {
        this.origins = origins;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public OriginGroupUpdatePropertiesParameters withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.responseBasedOriginErrorDetectionSettings;
    }

    public OriginGroupUpdatePropertiesParameters withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        this.responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings;
        return this;
    }

    public void validate() {
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.origins() != null) {
            this.origins().forEach(e -> e.validate());
        }
        if (this.responseBasedOriginErrorDetectionSettings() != null) {
            this.responseBasedOriginErrorDetectionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("healthProbeSettings", this.healthProbeSettings);
        jsonWriter.writeArrayField("origins", this.origins, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeNumberField("trafficRestorationTimeToHealedOrNewEndpointsInMinutes", this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        jsonWriter.writeJsonField("responseBasedOriginErrorDetectionSettings", this.responseBasedOriginErrorDetectionSettings);
        return jsonWriter.writeEndObject();
    }

    public static OriginGroupUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OriginGroupUpdatePropertiesParameters deserializedOriginGroupUpdatePropertiesParameters = new OriginGroupUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthProbeSettings".equals(fieldName)) {
                    deserializedOriginGroupUpdatePropertiesParameters.healthProbeSettings = HealthProbeParameters.fromJson(reader);
                    continue;
                }
                if ("origins".equals(fieldName)) {
                    List<ResourceReference> origins = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedOriginGroupUpdatePropertiesParameters.origins = origins;
                    continue;
                }
                if ("trafficRestorationTimeToHealedOrNewEndpointsInMinutes".equals(fieldName)) {
                    deserializedOriginGroupUpdatePropertiesParameters.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("responseBasedOriginErrorDetectionSettings".equals(fieldName)) {
                    deserializedOriginGroupUpdatePropertiesParameters.responseBasedOriginErrorDetectionSettings = ResponseBasedOriginErrorDetectionParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOriginGroupUpdatePropertiesParameters;
        });
    }
}

