/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MigrationWebApplicationFirewallMapping;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Sku;
import java.io.IOException;
import java.util.List;

public final class MigrationParameters
implements JsonSerializable<MigrationParameters> {
    private Sku sku;
    private ResourceReference classicResourceReference;
    private String profileName;
    private List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings;
    private static final ClientLogger LOGGER = new ClientLogger(MigrationParameters.class);

    public Sku sku() {
        return this.sku;
    }

    public MigrationParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public ResourceReference classicResourceReference() {
        return this.classicResourceReference;
    }

    public MigrationParameters withClassicResourceReference(ResourceReference classicResourceReference) {
        this.classicResourceReference = classicResourceReference;
        return this;
    }

    public String profileName() {
        return this.profileName;
    }

    public MigrationParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings() {
        return this.migrationWebApplicationFirewallMappings;
    }

    public MigrationParameters withMigrationWebApplicationFirewallMappings(List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings) {
        this.migrationWebApplicationFirewallMappings = migrationWebApplicationFirewallMappings;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sku in model MigrationParameters"));
        }
        this.sku().validate();
        if (this.classicResourceReference() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property classicResourceReference in model MigrationParameters"));
        }
        this.classicResourceReference().validate();
        if (this.profileName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property profileName in model MigrationParameters"));
        }
        if (this.migrationWebApplicationFirewallMappings() != null) {
            this.migrationWebApplicationFirewallMappings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("classicResourceReference", this.classicResourceReference);
        jsonWriter.writeStringField("profileName", this.profileName);
        jsonWriter.writeArrayField("migrationWebApplicationFirewallMappings", this.migrationWebApplicationFirewallMappings, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static MigrationParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationParameters deserializedMigrationParameters = new MigrationParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedMigrationParameters.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("classicResourceReference".equals(fieldName)) {
                    deserializedMigrationParameters.classicResourceReference = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("profileName".equals(fieldName)) {
                    deserializedMigrationParameters.profileName = reader.getString();
                    continue;
                }
                if ("migrationWebApplicationFirewallMappings".equals(fieldName)) {
                    List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings = reader.readArray(reader1 -> MigrationWebApplicationFirewallMapping.fromJson(reader1));
                    deserializedMigrationParameters.migrationWebApplicationFirewallMappings = migrationWebApplicationFirewallMappings;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationParameters;
        });
    }
}

