/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.KeyVaultSigningKeyParameters;
import java.io.IOException;

public final class UrlSigningKey
implements JsonSerializable<UrlSigningKey> {
    private String keyId;
    private KeyVaultSigningKeyParameters keySourceParameters;
    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningKey.class);

    public String keyId() {
        return this.keyId;
    }

    public UrlSigningKey withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public KeyVaultSigningKeyParameters keySourceParameters() {
        return this.keySourceParameters;
    }

    public UrlSigningKey withKeySourceParameters(KeyVaultSigningKeyParameters keySourceParameters) {
        this.keySourceParameters = keySourceParameters;
        return this;
    }

    public void validate() {
        if (this.keyId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property keyId in model UrlSigningKey"));
        }
        if (this.keySourceParameters() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property keySourceParameters in model UrlSigningKey"));
        }
        this.keySourceParameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("keySourceParameters", this.keySourceParameters);
        return jsonWriter.writeEndObject();
    }

    public static UrlSigningKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlSigningKey deserializedUrlSigningKey = new UrlSigningKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyId".equals(fieldName)) {
                    deserializedUrlSigningKey.keyId = reader.getString();
                    continue;
                }
                if ("keySourceParameters".equals(fieldName)) {
                    deserializedUrlSigningKey.keySourceParameters = KeyVaultSigningKeyParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlSigningKey;
        });
    }
}

