/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.VirtualMachineUpdateInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.implementation.VirtualMachineImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ResourceIdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineIdentityUserAssignedIdentities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

class VirtualMachineMsiHandler
extends RoleAssignmentHelper {
    private final VirtualMachineImpl virtualMachine;
    private List<String> creatableIdentityKeys;
    private Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities;
    private final ClientLogger logger = new ClientLogger(VirtualMachineMsiHandler.class);

    VirtualMachineMsiHandler(AuthorizationManager authorizationManager, VirtualMachineImpl virtualMachine) {
        super(authorizationManager, virtualMachine.taskGroup(), virtualMachine.idProvider());
        this.virtualMachine = virtualMachine;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, VirtualMachineIdentityUserAssignedIdentities>();
    }

    VirtualMachineMsiHandler withLocalManagedServiceIdentity() {
        this.initVMIdentity(ResourceIdentityType.SYSTEM_ASSIGNED);
        return this;
    }

    VirtualMachineMsiHandler withoutLocalManagedServiceIdentity() {
        if (((VirtualMachineInner)this.virtualMachine.innerModel()).identity() == null || ((VirtualMachineInner)this.virtualMachine.innerModel()).identity().type() == null || ((VirtualMachineInner)this.virtualMachine.innerModel()).identity().type().equals((Object)ResourceIdentityType.NONE) || ((VirtualMachineInner)this.virtualMachine.innerModel()).identity().type().equals((Object)ResourceIdentityType.USER_ASSIGNED)) {
            return this;
        }
        if (((VirtualMachineInner)this.virtualMachine.innerModel()).identity().type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            ((VirtualMachineInner)this.virtualMachine.innerModel()).identity().withType(ResourceIdentityType.NONE);
        } else if (((VirtualMachineInner)this.virtualMachine.innerModel()).identity().type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
            ((VirtualMachineInner)this.virtualMachine.innerModel()).identity().withType(ResourceIdentityType.USER_ASSIGNED);
        }
        return this;
    }

    VirtualMachineMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initVMIdentity(ResourceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatableIdentity);
        Objects.requireNonNull(dependency);
        this.virtualMachine.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    VirtualMachineMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initVMIdentity(ResourceIdentityType.USER_ASSIGNED);
        this.userAssignedIdentities.put(identity.id(), new VirtualMachineIdentityUserAssignedIdentities());
        return this;
    }

    VirtualMachineMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        this.userAssignedIdentities.put(identityId, null);
        return this;
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.virtualMachine.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new VirtualMachineIdentityUserAssignedIdentities());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        if (!this.userAssignedIdentities.isEmpty()) {
            ((VirtualMachineInner)this.virtualMachine.innerModel()).identity().withUserAssignedIdentities(this.userAssignedIdentities);
        }
    }

    void handleExternalIdentities(VirtualMachineUpdateInner vmUpdate) {
        if (this.handleRemoveAllExternalIdentitiesCase(vmUpdate)) {
            return;
        }
        VirtualMachineIdentity currentIdentity = ((VirtualMachineInner)this.virtualMachine.innerModel()).identity();
        vmUpdate.withIdentity(currentIdentity);
        if (!this.userAssignedIdentities.isEmpty()) {
            vmUpdate.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        } else if (currentIdentity != null) {
            currentIdentity.withUserAssignedIdentities(null);
        }
    }

    void clear() {
        this.userAssignedIdentities = new HashMap<String, VirtualMachineIdentityUserAssignedIdentities>();
    }

    private boolean handleRemoveAllExternalIdentitiesCase(VirtualMachineUpdateInner vmUpdate) {
        if (!this.userAssignedIdentities.isEmpty()) {
            boolean containsRemoveOnly;
            int rmCount = 0;
            for (VirtualMachineIdentityUserAssignedIdentities v : this.userAssignedIdentities.values()) {
                if (v != null) break;
                ++rmCount;
            }
            boolean bl = containsRemoveOnly = rmCount > 0 && rmCount == this.userAssignedIdentities.size();
            if (containsRemoveOnly) {
                boolean bl2;
                HashSet<String> currentIds = new HashSet<String>();
                VirtualMachineIdentity currentIdentity = ((VirtualMachineInner)this.virtualMachine.innerModel()).identity();
                if (currentIdentity != null && currentIdentity.userAssignedIdentities() != null) {
                    for (String string : currentIdentity.userAssignedIdentities().keySet()) {
                        currentIds.add(string.toLowerCase(Locale.ROOT));
                    }
                }
                HashSet<String> removeIds = new HashSet<String>();
                for (Map.Entry<String, VirtualMachineIdentityUserAssignedIdentities> entrySet : this.userAssignedIdentities.entrySet()) {
                    if (entrySet.getValue() != null) continue;
                    removeIds.add(entrySet.getKey().toLowerCase(Locale.ROOT));
                }
                boolean bl3 = bl2 = currentIds.size() == removeIds.size() && currentIds.containsAll(removeIds);
                if (bl2) {
                    if (currentIdentity == null || currentIdentity.type() == null) {
                        vmUpdate.withIdentity(new VirtualMachineIdentity().withType(ResourceIdentityType.NONE));
                    } else if (currentIdentity.type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
                        vmUpdate.withIdentity(currentIdentity);
                        vmUpdate.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED);
                    } else if (currentIdentity.type().equals((Object)ResourceIdentityType.USER_ASSIGNED)) {
                        vmUpdate.withIdentity(currentIdentity);
                        vmUpdate.identity().withType(ResourceIdentityType.NONE);
                    }
                    vmUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
                if (currentIds.size() == 0 && removeIds.size() != 0 && currentIdentity == null) {
                    vmUpdate.withIdentity(new VirtualMachineIdentity().withType(ResourceIdentityType.NONE));
                    vmUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
            }
        }
        return false;
    }

    private void initVMIdentity(ResourceIdentityType identityType) {
        if (!identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType)));
        }
        VirtualMachineInner virtualMachineInner = (VirtualMachineInner)this.virtualMachine.innerModel();
        if (virtualMachineInner.identity() == null) {
            virtualMachineInner.withIdentity(new VirtualMachineIdentity());
        }
        if (virtualMachineInner.identity().type() == null || virtualMachineInner.identity().type().equals((Object)ResourceIdentityType.NONE) || virtualMachineInner.identity().type().equals((Object)identityType)) {
            virtualMachineInner.identity().withType(identityType);
        } else {
            virtualMachineInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
    }
}

