/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CommunityGalleryInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GallerySharingPermissionTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SharingProfileGroup;
import java.io.IOException;
import java.util.List;

public final class SharingProfile
implements JsonSerializable<SharingProfile> {
    private GallerySharingPermissionTypes permissions;
    private List<SharingProfileGroup> groups;
    private CommunityGalleryInfo communityGalleryInfo;

    public GallerySharingPermissionTypes permissions() {
        return this.permissions;
    }

    public SharingProfile withPermissions(GallerySharingPermissionTypes permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<SharingProfileGroup> groups() {
        return this.groups;
    }

    public CommunityGalleryInfo communityGalleryInfo() {
        return this.communityGalleryInfo;
    }

    public SharingProfile withCommunityGalleryInfo(CommunityGalleryInfo communityGalleryInfo) {
        this.communityGalleryInfo = communityGalleryInfo;
        return this;
    }

    public void validate() {
        if (this.groups() != null) {
            this.groups().forEach(e -> e.validate());
        }
        if (this.communityGalleryInfo() != null) {
            this.communityGalleryInfo().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissions", this.permissions == null ? null : this.permissions.toString());
        jsonWriter.writeJsonField("communityGalleryInfo", this.communityGalleryInfo);
        return jsonWriter.writeEndObject();
    }

    public static SharingProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharingProfile deserializedSharingProfile = new SharingProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("permissions".equals(fieldName)) {
                    deserializedSharingProfile.permissions = GallerySharingPermissionTypes.fromString(reader.getString());
                    continue;
                }
                if ("groups".equals(fieldName)) {
                    List<SharingProfileGroup> groups2 = reader.readArray(reader1 -> SharingProfileGroup.fromJson(reader1));
                    deserializedSharingProfile.groups = groups2;
                    continue;
                }
                if ("communityGalleryInfo".equals(fieldName)) {
                    deserializedSharingProfile.communityGalleryInfo = CommunityGalleryInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharingProfile;
        });
    }
}

