/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.SecurityContextCapabilitiesDefinition;
import java.io.IOException;

public final class SecurityContextDefinition
implements JsonSerializable<SecurityContextDefinition> {
    private Boolean privileged;
    private Boolean allowPrivilegeEscalation;
    private SecurityContextCapabilitiesDefinition capabilities;
    private Integer runAsGroup;
    private Integer runAsUser;
    private String seccompProfile;

    public Boolean privileged() {
        return this.privileged;
    }

    public SecurityContextDefinition withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public Boolean allowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public SecurityContextDefinition withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    public SecurityContextCapabilitiesDefinition capabilities() {
        return this.capabilities;
    }

    public SecurityContextDefinition withCapabilities(SecurityContextCapabilitiesDefinition capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Integer runAsGroup() {
        return this.runAsGroup;
    }

    public SecurityContextDefinition withRunAsGroup(Integer runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    public Integer runAsUser() {
        return this.runAsUser;
    }

    public SecurityContextDefinition withRunAsUser(Integer runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public String seccompProfile() {
        return this.seccompProfile;
    }

    public SecurityContextDefinition withSeccompProfile(String seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("privileged", this.privileged);
        jsonWriter.writeBooleanField("allowPrivilegeEscalation", this.allowPrivilegeEscalation);
        jsonWriter.writeJsonField("capabilities", this.capabilities);
        jsonWriter.writeNumberField("runAsGroup", this.runAsGroup);
        jsonWriter.writeNumberField("runAsUser", this.runAsUser);
        jsonWriter.writeStringField("seccompProfile", this.seccompProfile);
        return jsonWriter.writeEndObject();
    }

    public static SecurityContextDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityContextDefinition deserializedSecurityContextDefinition = new SecurityContextDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privileged".equals(fieldName)) {
                    deserializedSecurityContextDefinition.privileged = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowPrivilegeEscalation".equals(fieldName)) {
                    deserializedSecurityContextDefinition.allowPrivilegeEscalation = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedSecurityContextDefinition.capabilities = SecurityContextCapabilitiesDefinition.fromJson(reader);
                    continue;
                }
                if ("runAsGroup".equals(fieldName)) {
                    deserializedSecurityContextDefinition.runAsGroup = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("runAsUser".equals(fieldName)) {
                    deserializedSecurityContextDefinition.runAsUser = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("seccompProfile".equals(fieldName)) {
                    deserializedSecurityContextDefinition.seccompProfile = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityContextDefinition;
        });
    }
}

