/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceTriggerEvent;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.TriggerStatus;
import java.io.IOException;
import java.util.List;

public final class SourceTrigger
implements JsonSerializable<SourceTrigger> {
    private SourceProperties sourceRepository;
    private List<SourceTriggerEvent> sourceTriggerEvents;
    private TriggerStatus status;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(SourceTrigger.class);

    public SourceProperties sourceRepository() {
        return this.sourceRepository;
    }

    public SourceTrigger withSourceRepository(SourceProperties sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    public List<SourceTriggerEvent> sourceTriggerEvents() {
        return this.sourceTriggerEvents;
    }

    public SourceTrigger withSourceTriggerEvents(List<SourceTriggerEvent> sourceTriggerEvents) {
        this.sourceTriggerEvents = sourceTriggerEvents;
        return this;
    }

    public TriggerStatus status() {
        return this.status;
    }

    public SourceTrigger withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SourceTrigger withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.sourceRepository() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sourceRepository in model SourceTrigger"));
        }
        this.sourceRepository().validate();
        if (this.sourceTriggerEvents() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sourceTriggerEvents in model SourceTrigger"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model SourceTrigger"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceRepository", this.sourceRepository);
        jsonWriter.writeArrayField("sourceTriggerEvents", this.sourceTriggerEvents, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static SourceTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceTrigger deserializedSourceTrigger = new SourceTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRepository".equals(fieldName)) {
                    deserializedSourceTrigger.sourceRepository = SourceProperties.fromJson(reader);
                    continue;
                }
                if ("sourceTriggerEvents".equals(fieldName)) {
                    List<SourceTriggerEvent> sourceTriggerEvents = reader.readArray(reader1 -> SourceTriggerEvent.fromString(reader1.getString()));
                    deserializedSourceTrigger.sourceTriggerEvents = sourceTriggerEvents;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSourceTrigger.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSourceTrigger.status = TriggerStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceTrigger;
        });
    }
}

