/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models.SnapshotProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.CreationData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OSSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.OSType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.SnapshotType;
import java.io.IOException;
import java.util.Map;

public final class SnapshotInner
extends Resource {
    private SnapshotProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private SnapshotProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SnapshotInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SnapshotInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public CreationData creationData() {
        return this.innerProperties() == null ? null : this.innerProperties().creationData();
    }

    public SnapshotInner withCreationData(CreationData creationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withCreationData(creationData);
        return this;
    }

    public SnapshotType snapshotType() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotType();
    }

    public SnapshotInner withSnapshotType(SnapshotType snapshotType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withSnapshotType(snapshotType);
        return this;
    }

    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    public String nodeImageVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeImageVersion();
    }

    public OSType osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public OSSku osSku() {
        return this.innerProperties() == null ? null : this.innerProperties().osSku();
    }

    public String vmSize() {
        return this.innerProperties() == null ? null : this.innerProperties().vmSize();
    }

    public Boolean enableFips() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFips();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotInner deserializedSnapshotInner = new SnapshotInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSnapshotInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSnapshotInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnapshotInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSnapshotInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSnapshotInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotInner.innerProperties = SnapshotProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSnapshotInner.systemData = SystemData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotInner;
        });
    }
}

