/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CassandraPartitionKey;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ClusterKey;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.Column;
import java.io.IOException;
import java.util.List;

public final class CassandraSchema
implements JsonSerializable<CassandraSchema> {
    private List<Column> columns;
    private List<CassandraPartitionKey> partitionKeys;
    private List<ClusterKey> clusterKeys;

    public List<Column> columns() {
        return this.columns;
    }

    public CassandraSchema withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public List<CassandraPartitionKey> partitionKeys() {
        return this.partitionKeys;
    }

    public CassandraSchema withPartitionKeys(List<CassandraPartitionKey> partitionKeys) {
        this.partitionKeys = partitionKeys;
        return this;
    }

    public List<ClusterKey> clusterKeys() {
        return this.clusterKeys;
    }

    public CassandraSchema withClusterKeys(List<ClusterKey> clusterKeys) {
        this.clusterKeys = clusterKeys;
        return this;
    }

    public void validate() {
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
        if (this.partitionKeys() != null) {
            this.partitionKeys().forEach(e -> e.validate());
        }
        if (this.clusterKeys() != null) {
            this.clusterKeys().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("partitionKeys", this.partitionKeys, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("clusterKeys", this.clusterKeys, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static CassandraSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraSchema deserializedCassandraSchema = new CassandraSchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("columns".equals(fieldName)) {
                    List<Column> columns = reader.readArray(reader1 -> Column.fromJson(reader1));
                    deserializedCassandraSchema.columns = columns;
                    continue;
                }
                if ("partitionKeys".equals(fieldName)) {
                    List<CassandraPartitionKey> partitionKeys = reader.readArray(reader1 -> CassandraPartitionKey.fromJson(reader1));
                    deserializedCassandraSchema.partitionKeys = partitionKeys;
                    continue;
                }
                if ("clusterKeys".equals(fieldName)) {
                    List<ClusterKey> clusterKeys = reader.readArray(reader1 -> ClusterKey.fromJson(reader1));
                    deserializedCassandraSchema.clusterKeys = clusterKeys;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraSchema;
        });
    }
}

