/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.SqlDatabaseResource;
import java.io.IOException;

public final class SqlDatabaseGetPropertiesResource
extends SqlDatabaseResource {
    private String colls;
    private String users;
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(SqlDatabaseGetPropertiesResource.class);

    public String colls() {
        return this.colls;
    }

    public SqlDatabaseGetPropertiesResource withColls(String colls) {
        this.colls = colls;
        return this;
    }

    public String users() {
        return this.users;
    }

    public SqlDatabaseGetPropertiesResource withUsers(String users) {
        this.users = users;
        return this;
    }

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public SqlDatabaseGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SqlDatabaseGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public SqlDatabaseGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model SqlDatabaseGetPropertiesResource"));
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        jsonWriter.writeStringField("_colls", this.colls);
        jsonWriter.writeStringField("_users", this.users);
        return jsonWriter.writeEndObject();
    }

    public static SqlDatabaseGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlDatabaseGetPropertiesResource deserializedSqlDatabaseGetPropertiesResource = new SqlDatabaseGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("_colls".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.colls = reader.getString();
                    continue;
                }
                if ("_users".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.users = reader.getString();
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedSqlDatabaseGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlDatabaseGetPropertiesResource;
        });
    }
}

