/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.core.management.SystemData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.EHNamespaceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.Encryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.TlsVersion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class EHNamespaceInner
extends Resource {
    private Sku sku;
    private Identity identity;
    private SystemData systemData;
    private EHNamespaceProperties innerProperties;
    private String id;
    private String name;
    private String type;

    public Sku sku() {
        return this.sku;
    }

    public EHNamespaceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public EHNamespaceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private EHNamespaceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public EHNamespaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public EHNamespaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public EHNamespaceInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public String serviceBusEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusEndpoint();
    }

    public String clusterArmId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterArmId();
    }

    public EHNamespaceInner withClusterArmId(String clusterArmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withClusterArmId(clusterArmId);
        return this;
    }

    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    public Boolean isAutoInflateEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isAutoInflateEnabled();
    }

    public EHNamespaceInner withIsAutoInflateEnabled(Boolean isAutoInflateEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withIsAutoInflateEnabled(isAutoInflateEnabled);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public EHNamespaceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Integer maximumThroughputUnits() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumThroughputUnits();
    }

    public EHNamespaceInner withMaximumThroughputUnits(Integer maximumThroughputUnits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withMaximumThroughputUnits(maximumThroughputUnits);
        return this;
    }

    public Boolean kafkaEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().kafkaEnabled();
    }

    public EHNamespaceInner withKafkaEnabled(Boolean kafkaEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withKafkaEnabled(kafkaEnabled);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public EHNamespaceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public EHNamespaceInner withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public EHNamespaceInner withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public EHNamespaceInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public String alternateName() {
        return this.innerProperties() == null ? null : this.innerProperties().alternateName();
    }

    public EHNamespaceInner withAlternateName(String alternateName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EHNamespaceProperties();
        }
        this.innerProperties().withAlternateName(alternateName);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EHNamespaceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EHNamespaceInner deserializedEHNamespaceInner = new EHNamespaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEHNamespaceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEHNamespaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEHNamespaceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedEHNamespaceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedEHNamespaceInner.withTags((Map)tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedEHNamespaceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedEHNamespaceInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedEHNamespaceInner.systemData = SystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEHNamespaceInner.innerProperties = EHNamespaceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEHNamespaceInner;
        });
    }
}

