/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models.EHNamespaceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHub;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespaceAuthorizationRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespaceSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.TlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.VoidIndexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.UUID;

class EventHubNamespaceImpl
extends GroupableResourceImpl<EventHubNamespace, EHNamespaceInner, EventHubNamespaceImpl, EventHubsManager>
implements EventHubNamespace,
EventHubNamespace.Definition,
EventHubNamespace.Update {
    private Flux<Indexable> postRunTasks;

    protected EventHubNamespaceImpl(String name, EHNamespaceInner innerObject, EventHubsManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    public EventHubNamespaceSkuType sku() {
        return new EventHubNamespaceSkuType(((EHNamespaceInner)this.innerModel()).sku());
    }

    @Override
    public String azureInsightMetricId() {
        return ((EHNamespaceInner)this.innerModel()).metricId();
    }

    @Override
    public String serviceBusEndpoint() {
        return ((EHNamespaceInner)this.innerModel()).serviceBusEndpoint();
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((EHNamespaceInner)this.innerModel()).createdAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((EHNamespaceInner)this.innerModel()).updatedAt();
    }

    @Override
    public String provisioningState() {
        return ((EHNamespaceInner)this.innerModel()).provisioningState();
    }

    @Override
    public boolean isAutoScaleEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((EHNamespaceInner)this.innerModel()).isAutoInflateEnabled());
    }

    @Override
    public int currentThroughputUnits() {
        return ResourceManagerUtils.toPrimitiveInt(((EHNamespaceInner)this.innerModel()).sku().capacity());
    }

    @Override
    public int throughputUnitsUpperLimit() {
        return ResourceManagerUtils.toPrimitiveInt(((EHNamespaceInner)this.innerModel()).maximumThroughputUnits());
    }

    @Override
    public EventHubNamespaceImpl withNewEventHub(String eventHubName) {
        this.concatPostRunTask(((EventHub.DefinitionStages.Blank)((EventHubsManager)this.manager()).eventHubs().define(eventHubName)).withExistingNamespace(this.resourceGroupName(), this.name()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewEventHub(String eventHubName, int partitionCount) {
        this.concatPostRunTask(((EventHub.DefinitionStages.Blank)((EventHubsManager)this.manager()).eventHubs().define(eventHubName)).withExistingNamespace(this.resourceGroupName(), this.name()).withPartitionCount(partitionCount).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewEventHub(String eventHubName, int partitionCount, int retentionPeriodInDays) {
        this.concatPostRunTask(((EventHub.DefinitionStages.Blank)((EventHubsManager)this.manager()).eventHubs().define(eventHubName)).withExistingNamespace(this.resourceGroupName(), this.name()).withPartitionCount(partitionCount).withRetentionPeriodInDays(retentionPeriodInDays).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubNamespace.Update withoutEventHub(String eventHubName) {
        this.concatPostRunTask(((EventHubsManager)this.manager()).eventHubs().deleteByNameAsync(this.resourceGroupName(), this.name(), eventHubName).map(aVoid -> new VoidIndexable(UUID.randomUUID().toString())));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewSendRule(String ruleName) {
        this.concatPostRunTask(((EventHubNamespaceAuthorizationRule.DefinitionStages.WithCreate)((EventHubNamespaceAuthorizationRule.DefinitionStages.Blank)((EventHubsManager)this.manager()).namespaceAuthorizationRules().define(ruleName)).withExistingNamespace(this.resourceGroupName(), this.name()).withSendAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewListenRule(String ruleName) {
        this.concatPostRunTask(((EventHubNamespaceAuthorizationRule.DefinitionStages.WithCreate)((EventHubNamespaceAuthorizationRule.DefinitionStages.Blank)((EventHubsManager)this.manager()).namespaceAuthorizationRules().define(ruleName)).withExistingNamespace(this.resourceGroupName(), this.name()).withListenAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewManageRule(String ruleName) {
        this.concatPostRunTask(((EventHubNamespaceAuthorizationRule.DefinitionStages.WithCreate)((EventHubNamespaceAuthorizationRule.DefinitionStages.Blank)((EventHubsManager)this.manager()).namespaceAuthorizationRules().define(ruleName)).withExistingNamespace(this.resourceGroupName(), this.name()).withManageAccess()).createAsync().cast(Indexable.class));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withoutAuthorizationRule(String ruleName) {
        this.concatPostRunTask(((EventHubsManager)this.manager()).namespaceAuthorizationRules().deleteByNameAsync(this.resourceGroupName(), this.name(), ruleName).map(aVoid -> new VoidIndexable(UUID.randomUUID().toString())));
        return this;
    }

    @Override
    public EventHubNamespaceImpl withAutoScaling() {
        this.setDefaultSkuIfNotSet();
        ((EHNamespaceInner)this.innerModel()).withIsAutoInflateEnabled(true);
        if (((EHNamespaceInner)this.innerModel()).maximumThroughputUnits() == null) {
            this.withThroughputUnitsUpperLimit(20);
        }
        return this;
    }

    @Override
    public EventHubNamespaceImpl withSku(EventHubNamespaceSkuType namespaceSku) {
        boolean isDifferent;
        Sku newSkuInner = new Sku().withName(namespaceSku.name()).withTier(namespaceSku.tier()).withCapacity(null);
        Sku currentSkuInner = ((EHNamespaceInner)this.innerModel()).sku();
        boolean bl = isDifferent = currentSkuInner == null || !currentSkuInner.name().equals(newSkuInner.name());
        if (isDifferent) {
            ((EHNamespaceInner)this.innerModel()).withSku(newSkuInner);
            if (newSkuInner.name().equals(SkuName.STANDARD)) {
                newSkuInner.withCapacity(1);
            }
        }
        return this;
    }

    @Override
    public EventHubNamespaceImpl withCurrentThroughputUnits(int units) {
        this.setDefaultSkuIfNotSet();
        ((EHNamespaceInner)this.innerModel()).sku().withCapacity(units);
        return this;
    }

    @Override
    public EventHubNamespaceImpl withThroughputUnitsUpperLimit(int units) {
        ((EHNamespaceInner)this.innerModel()).withMaximumThroughputUnits(units);
        return this;
    }

    @Override
    public void beforeGroupCreateOrUpdate() {
        if (this.postRunTasks != null) {
            this.addPostRunDependent(context -> this.postRunTasks.last());
        }
    }

    @Override
    public Mono<EventHubNamespace> createResourceAsync() {
        return ((EventHubManagementClient)((EventHubsManager)this.manager()).serviceClient()).getNamespaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (EHNamespaceInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.postRunTasks = null;
        return Mono.empty();
    }

    @Override
    public PagedFlux<EventHub> listEventHubsAsync() {
        return ((EventHubsManager)this.manager()).eventHubs().listByNamespaceAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedFlux<EventHubNamespaceAuthorizationRule> listAuthorizationRulesAsync() {
        return ((EventHubsManager)this.manager()).namespaceAuthorizationRules().listByNamespaceAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedIterable<EventHub> listEventHubs() {
        return ((EventHubsManager)this.manager()).eventHubs().listByNamespace(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedIterable<EventHubNamespaceAuthorizationRule> listAuthorizationRules() {
        return ((EventHubsManager)this.manager()).namespaceAuthorizationRules().listByNamespace(this.resourceGroupName(), this.name());
    }

    @Override
    public TlsVersion minimumTlsVersion() {
        return ((EHNamespaceInner)this.innerModel()).minimumTlsVersion();
    }

    @Override
    public boolean zoneRedundant() {
        return ResourceManagerUtils.toPrimitiveBoolean(((EHNamespaceInner)this.innerModel()).zoneRedundant());
    }

    @Override
    protected Mono<EHNamespaceInner> getInnerAsync() {
        return ((EventHubManagementClient)((EventHubsManager)this.manager()).serviceClient()).getNamespaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private void setDefaultSkuIfNotSet() {
        if (((EHNamespaceInner)this.innerModel()).sku() == null) {
            this.withSku(EventHubNamespaceSkuType.STANDARD);
        }
    }

    private void concatPostRunTask(Mono<Indexable> task) {
        if (this.postRunTasks == null) {
            this.postRunTasks = Flux.empty();
        }
        this.postRunTasks = this.postRunTasks.concatWith(task);
    }

    @Override
    public EventHubNamespaceImpl withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        ((EHNamespaceInner)this.innerModel()).withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public EventHubNamespaceImpl enableZoneRedundant() {
        ((EHNamespaceInner)this.innerModel()).withZoneRedundant(true);
        return this;
    }
}

