/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.LogSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricSettings;
import java.io.IOException;
import java.util.List;

public final class DiagnosticSettings
implements JsonSerializable<DiagnosticSettings> {
    private String storageAccountId;
    private String serviceBusRuleId;
    private String eventHubAuthorizationRuleId;
    private String eventHubName;
    private List<MetricSettings> metrics;
    private List<LogSettings> logs;
    private String workspaceId;
    private String marketplacePartnerId;
    private String logAnalyticsDestinationType;

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public DiagnosticSettings withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public String serviceBusRuleId() {
        return this.serviceBusRuleId;
    }

    public DiagnosticSettings withServiceBusRuleId(String serviceBusRuleId) {
        this.serviceBusRuleId = serviceBusRuleId;
        return this;
    }

    public String eventHubAuthorizationRuleId() {
        return this.eventHubAuthorizationRuleId;
    }

    public DiagnosticSettings withEventHubAuthorizationRuleId(String eventHubAuthorizationRuleId) {
        this.eventHubAuthorizationRuleId = eventHubAuthorizationRuleId;
        return this;
    }

    public String eventHubName() {
        return this.eventHubName;
    }

    public DiagnosticSettings withEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
        return this;
    }

    public List<MetricSettings> metrics() {
        return this.metrics;
    }

    public DiagnosticSettings withMetrics(List<MetricSettings> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<LogSettings> logs() {
        return this.logs;
    }

    public DiagnosticSettings withLogs(List<LogSettings> logs) {
        this.logs = logs;
        return this;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public DiagnosticSettings withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public String marketplacePartnerId() {
        return this.marketplacePartnerId;
    }

    public DiagnosticSettings withMarketplacePartnerId(String marketplacePartnerId) {
        this.marketplacePartnerId = marketplacePartnerId;
        return this;
    }

    public String logAnalyticsDestinationType() {
        return this.logAnalyticsDestinationType;
    }

    public DiagnosticSettings withLogAnalyticsDestinationType(String logAnalyticsDestinationType) {
        this.logAnalyticsDestinationType = logAnalyticsDestinationType;
        return this;
    }

    public void validate() {
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
        if (this.logs() != null) {
            this.logs().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId);
        jsonWriter.writeStringField("serviceBusRuleId", this.serviceBusRuleId);
        jsonWriter.writeStringField("eventHubAuthorizationRuleId", this.eventHubAuthorizationRuleId);
        jsonWriter.writeStringField("eventHubName", this.eventHubName);
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("logs", this.logs, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("workspaceId", this.workspaceId);
        jsonWriter.writeStringField("marketplacePartnerId", this.marketplacePartnerId);
        jsonWriter.writeStringField("logAnalyticsDestinationType", this.logAnalyticsDestinationType);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticSettings deserializedDiagnosticSettings = new DiagnosticSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountId".equals(fieldName)) {
                    deserializedDiagnosticSettings.storageAccountId = reader.getString();
                    continue;
                }
                if ("serviceBusRuleId".equals(fieldName)) {
                    deserializedDiagnosticSettings.serviceBusRuleId = reader.getString();
                    continue;
                }
                if ("eventHubAuthorizationRuleId".equals(fieldName)) {
                    deserializedDiagnosticSettings.eventHubAuthorizationRuleId = reader.getString();
                    continue;
                }
                if ("eventHubName".equals(fieldName)) {
                    deserializedDiagnosticSettings.eventHubName = reader.getString();
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List<MetricSettings> metrics = reader.readArray(reader1 -> MetricSettings.fromJson(reader1));
                    deserializedDiagnosticSettings.metrics = metrics;
                    continue;
                }
                if ("logs".equals(fieldName)) {
                    List<LogSettings> logs = reader.readArray(reader1 -> LogSettings.fromJson(reader1));
                    deserializedDiagnosticSettings.logs = logs;
                    continue;
                }
                if ("workspaceId".equals(fieldName)) {
                    deserializedDiagnosticSettings.workspaceId = reader.getString();
                    continue;
                }
                if ("marketplacePartnerId".equals(fieldName)) {
                    deserializedDiagnosticSettings.marketplacePartnerId = reader.getString();
                    continue;
                }
                if ("logAnalyticsDestinationType".equals(fieldName)) {
                    deserializedDiagnosticSettings.logAnalyticsDestinationType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticSettings;
        });
    }
}

