/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConfigurationType;
import java.io.IOException;
import java.util.List;

public final class NetworkManagerCommitInner
implements JsonSerializable<NetworkManagerCommitInner> {
    private String commitId;
    private List<String> targetLocations;
    private List<String> configurationIds;
    private ConfigurationType commitType;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerCommitInner.class);

    public String commitId() {
        return this.commitId;
    }

    public List<String> targetLocations() {
        return this.targetLocations;
    }

    public NetworkManagerCommitInner withTargetLocations(List<String> targetLocations) {
        this.targetLocations = targetLocations;
        return this;
    }

    public List<String> configurationIds() {
        return this.configurationIds;
    }

    public NetworkManagerCommitInner withConfigurationIds(List<String> configurationIds) {
        this.configurationIds = configurationIds;
        return this;
    }

    public ConfigurationType commitType() {
        return this.commitType;
    }

    public NetworkManagerCommitInner withCommitType(ConfigurationType commitType) {
        this.commitType = commitType;
        return this;
    }

    public void validate() {
        if (this.targetLocations() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property targetLocations in model NetworkManagerCommitInner"));
        }
        if (this.commitType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property commitType in model NetworkManagerCommitInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", this.targetLocations, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("commitType", this.commitType == null ? null : this.commitType.toString());
        jsonWriter.writeArrayField("configurationIds", this.configurationIds, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerCommitInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerCommitInner deserializedNetworkManagerCommitInner = new NetworkManagerCommitInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetLocations".equals(fieldName)) {
                    List<String> targetLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerCommitInner.targetLocations = targetLocations;
                    continue;
                }
                if ("commitType".equals(fieldName)) {
                    deserializedNetworkManagerCommitInner.commitType = ConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("commitId".equals(fieldName)) {
                    deserializedNetworkManagerCommitInner.commitId = reader.getString();
                    continue;
                }
                if ("configurationIds".equals(fieldName)) {
                    List<String> configurationIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerCommitInner.configurationIds = configurationIds;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerCommitInner;
        });
    }
}

