/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.RouteFilterRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class RouteFilterPropertiesFormat
implements JsonSerializable<RouteFilterPropertiesFormat> {
    private List<RouteFilterRuleInner> rules;
    private List<ExpressRouteCircuitPeeringInner> peerings;
    private List<ExpressRouteCircuitPeeringInner> ipv6Peerings;
    private ProvisioningState provisioningState;

    public List<RouteFilterRuleInner> rules() {
        return this.rules;
    }

    public RouteFilterPropertiesFormat withRules(List<RouteFilterRuleInner> rules) {
        this.rules = rules;
        return this;
    }

    public List<ExpressRouteCircuitPeeringInner> peerings() {
        return this.peerings;
    }

    public List<ExpressRouteCircuitPeeringInner> ipv6Peerings() {
        return this.ipv6Peerings;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
        if (this.ipv6Peerings() != null) {
            this.ipv6Peerings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static RouteFilterPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteFilterPropertiesFormat deserializedRouteFilterPropertiesFormat = new RouteFilterPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    List<RouteFilterRuleInner> rules = reader.readArray(reader1 -> RouteFilterRuleInner.fromJson(reader1));
                    deserializedRouteFilterPropertiesFormat.rules = rules;
                    continue;
                }
                if ("peerings".equals(fieldName)) {
                    List<ExpressRouteCircuitPeeringInner> peerings = reader.readArray(reader1 -> ExpressRouteCircuitPeeringInner.fromJson(reader1));
                    deserializedRouteFilterPropertiesFormat.peerings = peerings;
                    continue;
                }
                if ("ipv6Peerings".equals(fieldName)) {
                    List<ExpressRouteCircuitPeeringInner> ipv6Peerings = reader.readArray(reader1 -> ExpressRouteCircuitPeeringInner.fromJson(reader1));
                    deserializedRouteFilterPropertiesFormat.ipv6Peerings = ipv6Peerings;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRouteFilterPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteFilterPropertiesFormat;
        });
    }
}

