/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayBackendHealthServerInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendHealthImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendServerHealthImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealth;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealthHttpSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfigurationHealth;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendServerHealth;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class ApplicationGatewayBackendHttpConfigurationHealthImpl
implements ApplicationGatewayBackendHttpConfigurationHealth {
    private final ApplicationGatewayBackendHealthHttpSettings inner;
    private final ApplicationGatewayBackendHealthImpl backendHealth;
    private final Map<String, ApplicationGatewayBackendServerHealth> serverHealths = new TreeMap<String, ApplicationGatewayBackendServerHealth>();

    ApplicationGatewayBackendHttpConfigurationHealthImpl(ApplicationGatewayBackendHealthHttpSettings inner, ApplicationGatewayBackendHealthImpl backendHealth) {
        this.inner = inner;
        this.backendHealth = backendHealth;
        if (inner.servers() != null) {
            for (ApplicationGatewayBackendHealthServerInner serverHealthInner : this.innerModel().servers()) {
                ApplicationGatewayBackendServerHealthImpl serverHealth = new ApplicationGatewayBackendServerHealthImpl(serverHealthInner, this);
                this.serverHealths.put(serverHealth.ipAddress(), serverHealth);
            }
        }
    }

    @Override
    public ApplicationGatewayBackendHealthHttpSettings innerModel() {
        return this.inner;
    }

    @Override
    public String name() {
        if (this.inner.backendHttpSettings() != null) {
            return ResourceUtils.nameFromResourceId(this.inner.backendHttpSettings().id());
        }
        return null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfiguration backendHttpConfiguration() {
        if (this.inner.backendHttpSettings() == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId(this.inner.backendHttpSettings().id());
        return ((ApplicationGateway)this.parent().parent()).backendHttpConfigurations().get(name);
    }

    @Override
    public ApplicationGatewayBackendHealth parent() {
        return this.backendHealth;
    }

    @Override
    public Map<String, ApplicationGatewayBackendServerHealth> serverHealths() {
        return Collections.unmodifiableMap(this.serverHealths);
    }
}

