/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpConfigurationBgpPeeringAddress;
import java.io.IOException;
import java.util.List;

public final class BgpSettings
implements JsonSerializable<BgpSettings> {
    private Long asn;
    private String bgpPeeringAddress;
    private Integer peerWeight;
    private List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses;

    public Long asn() {
        return this.asn;
    }

    public BgpSettings withAsn(Long asn) {
        this.asn = asn;
        return this;
    }

    public String bgpPeeringAddress() {
        return this.bgpPeeringAddress;
    }

    public BgpSettings withBgpPeeringAddress(String bgpPeeringAddress) {
        this.bgpPeeringAddress = bgpPeeringAddress;
        return this;
    }

    public Integer peerWeight() {
        return this.peerWeight;
    }

    public BgpSettings withPeerWeight(Integer peerWeight) {
        this.peerWeight = peerWeight;
        return this;
    }

    public List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses() {
        return this.bgpPeeringAddresses;
    }

    public BgpSettings withBgpPeeringAddresses(List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses) {
        this.bgpPeeringAddresses = bgpPeeringAddresses;
        return this;
    }

    public void validate() {
        if (this.bgpPeeringAddresses() != null) {
            this.bgpPeeringAddresses().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("asn", this.asn);
        jsonWriter.writeStringField("bgpPeeringAddress", this.bgpPeeringAddress);
        jsonWriter.writeNumberField("peerWeight", this.peerWeight);
        jsonWriter.writeArrayField("bgpPeeringAddresses", this.bgpPeeringAddresses, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static BgpSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpSettings deserializedBgpSettings = new BgpSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("asn".equals(fieldName)) {
                    deserializedBgpSettings.asn = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("bgpPeeringAddress".equals(fieldName)) {
                    deserializedBgpSettings.bgpPeeringAddress = reader.getString();
                    continue;
                }
                if ("peerWeight".equals(fieldName)) {
                    deserializedBgpSettings.peerWeight = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("bgpPeeringAddresses".equals(fieldName)) {
                    List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses = reader.readArray(reader1 -> IpConfigurationBgpPeeringAddress.fromJson(reader1));
                    deserializedBgpSettings.bgpPeeringAddresses = bgpPeeringAddresses;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpSettings;
        });
    }
}

