/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Arrays;

public class AuxiliaryAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_AUXILIARY_HEADER = "x-ms-authorization-auxiliary";
    private static final String SCHEMA_FORMAT = "Bearer %s";
    private final TokenCredential[] tokenCredentials;
    private final AzureEnvironment environment;

    public AuxiliaryAuthenticationPolicy(AzureEnvironment environment, TokenCredential ... credentials) {
        this.environment = environment;
        this.tokenCredentials = credentials;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (this.tokenCredentials == null || this.tokenCredentials.length == 0) {
            return next.process();
        }
        return Flux.fromIterable(Arrays.asList(this.tokenCredentials)).flatMap(credential -> {
            String defaultScope = ResourceManagerUtils.getDefaultScopeFromRequest(context.getHttpRequest(), this.environment);
            return credential.getToken(new TokenRequestContext().addScopes(defaultScope)).map(token -> String.format(SCHEMA_FORMAT, token.getToken()));
        }).collectList().flatMap(tokenList -> {
            context.getHttpRequest().setHeader(AUTHORIZATION_AUXILIARY_HEADER, String.join((CharSequence)",", tokenList));
            return next.process();
        });
    }
}

