/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PagedConverter {
    private PagedConverter() {
    }

    public static <T, S> PagedIterable<S> mapPage(PagedIterable<T> pageIterable, Function<T, S> mapper) {
        return new PagedIterableImpl(pageIterable, mapper);
    }

    public static <T, S> PagedFlux<S> mapPage(PagedFlux<T> pagedFlux, Function<T, S> mapper) {
        Supplier provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage().take(1L) : pagedFlux.byPage((String)continuationToken).take(1L);
            return flux.map(PagedConverter.mapPagedResponse(mapper));
        };
        return PagedFlux.create(provider);
    }

    public static <T, S> PagedFlux<S> flatMapPage(PagedFlux<T> pagedFlux, Function<? super T, ? extends Publisher<? extends S>> mapper) {
        Supplier provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage().take(1L) : pagedFlux.byPage((String)continuationToken).take(1L);
            return flux.concatMap(PagedConverter.flatMapPagedResponse(mapper));
        };
        return PagedFlux.create(provider);
    }

    public static <T, S> PagedFlux<S> mergePagedFlux(PagedFlux<T> pagedFlux, Function<? super T, PagedFlux<S>> transformer) {
        Supplier provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage((String)continuationToken);
            return flux.concatMap(PagedConverter.mergePagedFluxPagedResponse(transformer));
        };
        return PagedFlux.create(provider);
    }

    private static <T, S> Function<PagedResponse<T>, PagedResponse<S>> mapPagedResponse(Function<T, S> mapper) {
        return pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(mapper).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null);
    }

    private static <T, S> Function<PagedResponse<T>, Mono<PagedResponse<S>>> flatMapPagedResponse(Function<? super T, ? extends Publisher<? extends S>> mapper) {
        return pagedResponse -> Flux.fromIterable(pagedResponse.getValue()).flatMapSequential(mapper).collectList().map(values2 -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), values2, (String)pagedResponse.getContinuationToken(), null));
    }

    private static <T, S> Function<PagedResponse<T>, Flux<PagedResponse<S>>> mergePagedFluxPagedResponse(Function<? super T, PagedFlux<S>> transformer) {
        return pagedResponse -> {
            List fluxList = pagedResponse.getValue().stream().map(item -> ((PagedFlux)transformer.apply(item)).byPage()).collect(Collectors.toList());
            return Flux.concat(fluxList).filter(p -> !p.getValue().isEmpty());
        };
    }

    public static <T> PagedFlux<T> convertListToPagedFlux(Mono<Response<List<T>>> responseMono) {
        return new PagedFlux(() -> responseMono.map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, null)));
    }

    private static final class PagedIterableImpl<T, S>
    extends PagedIterable<S> {
        private final PagedIterable<T> pagedIterable;
        private final Function<T, S> mapper;
        private final Function<PagedResponse<T>, PagedResponse<S>> pageMapper;

        private PagedIterableImpl(PagedIterable<T> pagedIterable, Function<T, S> mapper) {
            super(PagedFlux.create(() -> (continuationToken, pageSize) -> Flux.fromStream(pagedIterable.streamByPage().map(PagedIterableImpl.getPageMapper(mapper)))));
            this.pagedIterable = pagedIterable;
            this.mapper = mapper;
            this.pageMapper = PagedIterableImpl.getPageMapper(mapper);
        }

        private static <T, S> Function<PagedResponse<T>, PagedResponse<S>> getPageMapper(Function<T, S> mapper) {
            return page -> new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), page.getElements().stream().map(mapper).collect(Collectors.toList()), (String)page.getContinuationToken(), null);
        }

        @Override
        public Stream<S> stream() {
            return this.pagedIterable.stream().map(this.mapper);
        }

        @Override
        public Stream<PagedResponse<S>> streamByPage() {
            return this.pagedIterable.streamByPage().map(this.pageMapper);
        }

        @Override
        public Stream<PagedResponse<S>> streamByPage(String continuationToken) {
            return this.pagedIterable.streamByPage(continuationToken).map(this.pageMapper);
        }

        @Override
        public Stream<PagedResponse<S>> streamByPage(int preferredPageSize) {
            return this.pagedIterable.streamByPage(preferredPageSize).map(this.pageMapper);
        }

        @Override
        public Stream<PagedResponse<S>> streamByPage(String continuationToken, int preferredPageSize) {
            return this.pagedIterable.streamByPage(continuationToken, preferredPageSize).map(this.pageMapper);
        }

        @Override
        public Iterator<S> iterator() {
            return new IteratorImpl(this.pagedIterable.iterator(), this.mapper);
        }

        @Override
        public Iterable<PagedResponse<S>> iterableByPage() {
            return new IterableImpl(this.pagedIterable.iterableByPage(), this.pageMapper);
        }

        @Override
        public Iterable<PagedResponse<S>> iterableByPage(String continuationToken) {
            return new IterableImpl(this.pagedIterable.iterableByPage(continuationToken), this.pageMapper);
        }

        @Override
        public Iterable<PagedResponse<S>> iterableByPage(int preferredPageSize) {
            return new IterableImpl(this.pagedIterable.iterableByPage(preferredPageSize), this.pageMapper);
        }

        @Override
        public Iterable<PagedResponse<S>> iterableByPage(String continuationToken, int preferredPageSize) {
            return new IterableImpl(this.pagedIterable.iterableByPage(continuationToken, preferredPageSize), this.pageMapper);
        }
    }

    private static final class IterableImpl<T, S>
    implements Iterable<S> {
        private final Iterable<T> iterable;
        private final Function<T, S> mapper;

        private IterableImpl(Iterable<T> iterable, Function<T, S> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public Iterator<S> iterator() {
            return new IteratorImpl(this.iterable.iterator(), this.mapper);
        }
    }

    private static final class IteratorImpl<T, S>
    implements Iterator<S> {
        private final Iterator<T> iterator;
        private final Function<T, S> mapper;

        private IteratorImpl(Iterator<T> iterator2, Function<T, S> mapper) {
            this.iterator = iterator2;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public S next() {
            return this.mapper.apply(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

