/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Encryption;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SBNamespaceUpdateProperties
implements JsonSerializable<SBNamespaceUpdateProperties> {
    private String provisioningState;
    private String status;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private String serviceBusEndpoint;
    private String metricId;
    private Encryption encryption;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private Boolean disableLocalAuth;
    private String alternateName;

    public String provisioningState() {
        return this.provisioningState;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    public String metricId() {
        return this.metricId;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SBNamespaceUpdateProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public SBNamespaceUpdateProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public SBNamespaceUpdateProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public String alternateName() {
        return this.alternateName;
    }

    public SBNamespaceUpdateProperties withAlternateName(String alternateName) {
        this.alternateName = alternateName;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryption", this.encryption);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("alternateName", this.alternateName);
        return jsonWriter.writeEndObject();
    }

    public static SBNamespaceUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBNamespaceUpdateProperties deserializedSBNamespaceUpdateProperties = new SBNamespaceUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.status = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.createdAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.updatedAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("serviceBusEndpoint".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.serviceBusEndpoint = reader.getString();
                    continue;
                }
                if ("metricId".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.metricId = reader.getString();
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedSBNamespaceUpdateProperties.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.disableLocalAuth = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("alternateName".equals(fieldName)) {
                    deserializedSBNamespaceUpdateProperties.alternateName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBNamespaceUpdateProperties;
        });
    }
}

