/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.QueuesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBQueueInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.QueueImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Queue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Queues;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class QueuesImpl
extends ServiceBusChildResourcesImpl<Queue, QueueImpl, SBQueueInner, QueuesClient, ServiceBusManager, ServiceBusNamespace>
implements Queues {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;
    private final ClientLogger logger = new ClientLogger(QueuesImpl.class);

    QueuesImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClient)manager.serviceClient()).getQueues(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    @Override
    public QueueImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Mono<Void> deleteByNameAsync(String name) {
        return ((QueuesClient)this.innerModel()).deleteAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Mono<SBQueueInner> getInnerByNameAsync(String name) {
        return ((QueuesClient)this.innerModel()).getAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected PagedFlux<SBQueueInner> listInnerAsync() {
        return ((QueuesClient)this.innerModel()).listByNamespaceAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedIterable<SBQueueInner> listInner() {
        return ((QueuesClient)this.innerModel()).listByNamespace(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected QueueImpl wrapModel(String name) {
        return new QueueImpl(this.resourceGroupName, this.namespaceName, name, this.region, new SBQueueInner(), (ServiceBusManager)this.manager());
    }

    @Override
    protected QueueImpl wrapModel(SBQueueInner inner) {
        if (inner == null) {
            return null;
        }
        return new QueueImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    @Override
    public PagedIterable<Queue> listByParent(String resourceGroupName, String parentName) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException());
    }

    @Override
    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException());
    }

    @Override
    public Mono<Queue> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException());
    }
}

