/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.BlobAuditingPolicyState;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class ServerBlobAuditingPolicyProperties
implements JsonSerializable<ServerBlobAuditingPolicyProperties> {
    private Boolean isDevopsAuditEnabled;
    private Integer retentionDays;
    private List<String> auditActionsAndGroups;
    private Boolean isStorageSecondaryKeyInUse;
    private Boolean isAzureMonitorTargetEnabled;
    private Integer queueDelayMs;
    private Boolean isManagedIdentityInUse;
    private BlobAuditingPolicyState state;
    private String storageEndpoint;
    private String storageAccountAccessKey;
    private UUID storageAccountSubscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ServerBlobAuditingPolicyProperties.class);

    public Boolean isDevopsAuditEnabled() {
        return this.isDevopsAuditEnabled;
    }

    public ServerBlobAuditingPolicyProperties withIsDevopsAuditEnabled(Boolean isDevopsAuditEnabled) {
        this.isDevopsAuditEnabled = isDevopsAuditEnabled;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public ServerBlobAuditingPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public List<String> auditActionsAndGroups() {
        return this.auditActionsAndGroups;
    }

    public ServerBlobAuditingPolicyProperties withAuditActionsAndGroups(List<String> auditActionsAndGroups) {
        this.auditActionsAndGroups = auditActionsAndGroups;
        return this;
    }

    public Boolean isStorageSecondaryKeyInUse() {
        return this.isStorageSecondaryKeyInUse;
    }

    public ServerBlobAuditingPolicyProperties withIsStorageSecondaryKeyInUse(Boolean isStorageSecondaryKeyInUse) {
        this.isStorageSecondaryKeyInUse = isStorageSecondaryKeyInUse;
        return this;
    }

    public Boolean isAzureMonitorTargetEnabled() {
        return this.isAzureMonitorTargetEnabled;
    }

    public ServerBlobAuditingPolicyProperties withIsAzureMonitorTargetEnabled(Boolean isAzureMonitorTargetEnabled) {
        this.isAzureMonitorTargetEnabled = isAzureMonitorTargetEnabled;
        return this;
    }

    public Integer queueDelayMs() {
        return this.queueDelayMs;
    }

    public ServerBlobAuditingPolicyProperties withQueueDelayMs(Integer queueDelayMs) {
        this.queueDelayMs = queueDelayMs;
        return this;
    }

    public Boolean isManagedIdentityInUse() {
        return this.isManagedIdentityInUse;
    }

    public ServerBlobAuditingPolicyProperties withIsManagedIdentityInUse(Boolean isManagedIdentityInUse) {
        this.isManagedIdentityInUse = isManagedIdentityInUse;
        return this;
    }

    public BlobAuditingPolicyState state() {
        return this.state;
    }

    public ServerBlobAuditingPolicyProperties withState(BlobAuditingPolicyState state) {
        this.state = state;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public ServerBlobAuditingPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public ServerBlobAuditingPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public UUID storageAccountSubscriptionId() {
        return this.storageAccountSubscriptionId;
    }

    public ServerBlobAuditingPolicyProperties withStorageAccountSubscriptionId(UUID storageAccountSubscriptionId) {
        this.storageAccountSubscriptionId = storageAccountSubscriptionId;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property state in model ServerBlobAuditingPolicyProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("isDevopsAuditEnabled", this.isDevopsAuditEnabled);
        jsonWriter.writeNumberField("retentionDays", this.retentionDays);
        jsonWriter.writeArrayField("auditActionsAndGroups", this.auditActionsAndGroups, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("isStorageSecondaryKeyInUse", this.isStorageSecondaryKeyInUse);
        jsonWriter.writeBooleanField("isAzureMonitorTargetEnabled", this.isAzureMonitorTargetEnabled);
        jsonWriter.writeNumberField("queueDelayMs", this.queueDelayMs);
        jsonWriter.writeBooleanField("isManagedIdentityInUse", this.isManagedIdentityInUse);
        jsonWriter.writeStringField("storageEndpoint", this.storageEndpoint);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeStringField("storageAccountSubscriptionId", Objects.toString(this.storageAccountSubscriptionId, null));
        return jsonWriter.writeEndObject();
    }

    public static ServerBlobAuditingPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerBlobAuditingPolicyProperties deserializedServerBlobAuditingPolicyProperties = new ServerBlobAuditingPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.state = BlobAuditingPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("isDevopsAuditEnabled".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.isDevopsAuditEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("retentionDays".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.retentionDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("auditActionsAndGroups".equals(fieldName)) {
                    List<String> auditActionsAndGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedServerBlobAuditingPolicyProperties.auditActionsAndGroups = auditActionsAndGroups;
                    continue;
                }
                if ("isStorageSecondaryKeyInUse".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.isStorageSecondaryKeyInUse = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isAzureMonitorTargetEnabled".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.isAzureMonitorTargetEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("queueDelayMs".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.queueDelayMs = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isManagedIdentityInUse".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.isManagedIdentityInUse = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageEndpoint".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.storageEndpoint = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("storageAccountSubscriptionId".equals(fieldName)) {
                    deserializedServerBlobAuditingPolicyProperties.storageAccountSubscriptionId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerBlobAuditingPolicyProperties;
        });
    }
}

