/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.DeletedServersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.DeletedServerInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DeletedServerListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class DeletedServersClientImpl
implements DeletedServersClient {
    private final DeletedServersService service;
    private final SqlManagementClientImpl client;

    DeletedServersClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(DeletedServersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedServerInner> listAsync() {
        return new PagedFlux<DeletedServerInner>(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeletedServerInner> listAsync(Context context) {
        return new PagedFlux<DeletedServerInner>(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedServerInner> list() {
        return new PagedIterable<DeletedServerInner>(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedServerInner> list(Context context) {
        return new PagedIterable<DeletedServerInner>(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listByLocationSinglePageAsync(String locationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocation(this.client.getEndpoint(), locationName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listByLocationSinglePageAsync(String locationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocation(this.client.getEndpoint(), locationName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedServerInner> listByLocationAsync(String locationName) {
        return new PagedFlux<DeletedServerInner>(() -> this.listByLocationSinglePageAsync(locationName), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeletedServerInner> listByLocationAsync(String locationName, Context context) {
        return new PagedFlux<DeletedServerInner>(() -> this.listByLocationSinglePageAsync(locationName, context), nextLink -> this.listByLocationNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedServerInner> listByLocation(String locationName) {
        return new PagedIterable<DeletedServerInner>(this.listByLocationAsync(locationName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedServerInner> listByLocation(String locationName, Context context) {
        return new PagedIterable<DeletedServerInner>(this.listByLocationAsync(locationName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedServerInner>> getWithResponseAsync(String locationName, String deletedServerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (deletedServerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), locationName, deletedServerName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeletedServerInner>> getWithResponseAsync(String locationName, String deletedServerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (deletedServerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), locationName, deletedServerName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedServerInner> getAsync(String locationName, String deletedServerName) {
        return this.getWithResponseAsync(locationName, deletedServerName).flatMap(res -> Mono.justOrEmpty((DeletedServerInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedServerInner> getWithResponse(String locationName, String deletedServerName, Context context) {
        return this.getWithResponseAsync(locationName, deletedServerName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedServerInner get(String locationName, String deletedServerName) {
        return this.getWithResponse(locationName, deletedServerName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> recoverWithResponseAsync(String locationName, String deletedServerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (deletedServerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recover(this.client.getEndpoint(), locationName, deletedServerName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> recoverWithResponseAsync(String locationName, String deletedServerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (deletedServerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.recover(this.client.getEndpoint(), locationName, deletedServerName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeletedServerInner>, DeletedServerInner> beginRecoverAsync(String locationName, String deletedServerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.recoverWithResponseAsync(locationName, deletedServerName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeletedServerInner.class), (Type)((Object)DeletedServerInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeletedServerInner>, DeletedServerInner> beginRecoverAsync(String locationName, String deletedServerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.recoverWithResponseAsync(locationName, deletedServerName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeletedServerInner.class), (Type)((Object)DeletedServerInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeletedServerInner>, DeletedServerInner> beginRecover(String locationName, String deletedServerName) {
        return this.beginRecoverAsync(locationName, deletedServerName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeletedServerInner>, DeletedServerInner> beginRecover(String locationName, String deletedServerName, Context context) {
        return this.beginRecoverAsync(locationName, deletedServerName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedServerInner> recoverAsync(String locationName, String deletedServerName) {
        return this.beginRecoverAsync(locationName, deletedServerName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeletedServerInner> recoverAsync(String locationName, String deletedServerName, Context context) {
        return this.beginRecoverAsync(locationName, deletedServerName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedServerInner recover(String locationName, String deletedServerName) {
        return this.recoverAsync(locationName, deletedServerName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedServerInner recover(String locationName, String deletedServerName, Context context) {
        return this.recoverAsync(locationName, deletedServerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeletedServerInner>> listByLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByLocationNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DeletedServerInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedServerListResult)res.getValue()).value(), ((DeletedServerListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    public static interface DeletedServersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/deletedServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedServerListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/deletedServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedServerListResult>> listByLocation(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/deletedServers/{deletedServerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedServerInner>> get(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="deletedServerName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/deletedServers/{deletedServerName}/recover")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> recover(@HostParam(value="$host") String var1, @PathParam(value="locationName") String var2, @PathParam(value="deletedServerName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedServerListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedServerListResult>> listByLocationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

