/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.CryptographyUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.HashAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.SignatureHashResolver;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.SecretMinClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyOperationResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultKeysModelsUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVerifyResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.SecretKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.SecretRequestAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;

public final class CryptographyClientImpl {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyClientImpl.class);
    private final KeyClientImpl keyClient;
    private final SecretMinClientImpl secretClient;
    private final String keyId;
    private final String vaultUrl;
    private final String keyCollection;
    private final String keyName;
    private final String keyVersion;

    public CryptographyClientImpl(String keyId, HttpPipeline pipeline, CryptographyServiceVersion serviceVersion) {
        Objects.requireNonNull(keyId);
        List<String> data = CryptographyUtils.unpackAndValidateId(keyId, LOGGER);
        this.vaultUrl = data.get(0);
        this.keyCollection = data.get(1);
        this.keyName = data.get(2);
        this.keyVersion = data.get(3);
        this.keyId = keyId;
        this.keyClient = new KeyClientImpl(pipeline, serviceVersion.getVersion());
        this.secretClient = new SecretMinClientImpl(pipeline, serviceVersion.getVersion());
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getKeyCollection() {
        return this.keyCollection;
    }

    public Mono<Response<KeyVaultKey>> getKeyAsync() {
        return this.keyClient.getKeyWithResponseAsync(this.vaultUrl, this.keyName, this.keyVersion).doOnRequest(ignored -> LOGGER.verbose("Retrieving key - {}", this.keyName)).doOnSuccess(response -> LOGGER.verbose("Retrieved key - {}", this.keyName)).doOnError(error -> LOGGER.warning("Failed to get key - {}", this.keyName, error)).onErrorMap(KeyVaultErrorException.class, KeyVaultKeysUtils::mapGetKeyException).map(response -> new SimpleResponse<KeyVaultKey>((Response<?>)response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
    }

    public Response<KeyVaultKey> getKey(Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.keyClient.getKeyWithResponse(this.vaultUrl, this.keyName, this.keyVersion, context), KeyVaultKeysUtils::mapGetKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    public Mono<JsonWebKey> getSecretKeyAsync() {
        return FluxUtil.withContext(context -> this.secretClient.getSecretWithResponseAsync(this.vaultUrl, this.keyName, this.keyVersion, (Context)context)).doOnRequest(ignored -> LOGGER.verbose("Retrieving key - {}", this.keyName)).doOnSuccess(response -> LOGGER.verbose("Retrieved key - {}", ((SecretKey)response.getValue()).getName())).doOnError(error -> LOGGER.warning("Failed to get key - {}", this.keyName, error)).map(response -> CryptographyUtils.transformSecretKey((SecretKey)response.getValue()));
    }

    public JsonWebKey getSecretKey() {
        return CryptographyUtils.transformSecretKey(this.secretClient.getSecretWithResponse(this.vaultUrl, this.keyName, this.keyVersion, Context.NONE).getValue());
    }

    public Mono<Response<SecretKey>> setSecretKeyAsync(SecretKey secret, Context context) {
        Objects.requireNonNull(secret, "The secret key cannot be null.");
        return this.secretClient.setSecretWithResponseAsync(this.vaultUrl, secret.getName(), secret.getValue(), secret.getProperties().getTags(), secret.getProperties().getContentType(), new SecretRequestAttributes(secret.getProperties()), context).doOnRequest(ignored -> LOGGER.verbose("Setting secret - {}", secret.getName())).doOnSuccess(response -> LOGGER.verbose("Set secret - {}", ((SecretKey)response.getValue()).getName())).doOnError(error -> LOGGER.warning("Failed to set secret - {}", secret.getName(), error));
    }

    public Response<SecretKey> setSecretKey(SecretKey secret, Context context) {
        Objects.requireNonNull(secret, "The Secret input parameter cannot be null.");
        return this.secretClient.setSecretWithResponse(this.vaultUrl, secret.getName(), secret.getValue(), secret.getProperties().getTags(), secret.getProperties().getContentType(), new SecretRequestAttributes(secret.getProperties()), context);
    }

    public Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        return this.encryptAsync(algorithm, plaintext, null, null, context);
    }

    public Mono<EncryptResult> encryptAsync(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encryptAsync(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), encryptParameters.getIv(), encryptParameters.getAdditionalAuthenticatedData(), context);
    }

    private Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plainText, byte[] iv, byte[] additionalAuthenticatedData, Context context) {
        return this.keyClient.encryptAsync(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), plainText, iv, additionalAuthenticatedData, null, context).doOnRequest(ignored -> LOGGER.verbose("Encrypting content with algorithm - {}", algorithm)).doOnSuccess(response -> LOGGER.verbose("Retrieved encrypted content with algorithm - {}", algorithm)).doOnError(error -> LOGGER.warning("Failed to encrypt content with algorithm - {}", algorithm, error)).map(result -> new EncryptResult(result.getResult(), algorithm, this.keyId, result.getIv(), result.getAuthenticationTag(), result.getAdditionalAuthenticatedData()));
    }

    public EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        return this.encrypt(algorithm, plaintext, null, null, context);
    }

    public EncryptResult encrypt(EncryptParameters encryptParameters, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encrypt(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), encryptParameters.getIv(), encryptParameters.getAdditionalAuthenticatedData(), context);
    }

    private EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plainText, byte[] iv, byte[] additionalAuthenticatedData, Context context) {
        KeyOperationResult result = this.keyClient.encryptWithResponse(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), plainText, iv, additionalAuthenticatedData, null, context).getValue();
        return new EncryptResult(result.getResult(), algorithm, this.keyId, result.getIv(), result.getAuthenticationTag(), result.getAdditionalAuthenticatedData());
    }

    public Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        return this.decryptAsync(algorithm, ciphertext, null, null, null, context);
    }

    public Mono<DecryptResult> decryptAsync(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decryptAsync(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), decryptParameters.getIv(), decryptParameters.getAdditionalAuthenticatedData(), decryptParameters.getAuthenticationTag(), context);
    }

    private Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] additionalAuthenticatedData, byte[] authenticationTag, Context context) {
        return this.keyClient.decryptAsync(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), ciphertext, iv, additionalAuthenticatedData, authenticationTag, context).map(result -> new DecryptResult(result.getResult(), algorithm, this.keyId)).doOnRequest(ignored -> LOGGER.verbose("Decrypting content with algorithm - {}", algorithm)).doOnSuccess(response -> LOGGER.verbose("Retrieved decrypted content with algorithm - {}", algorithm)).doOnError(error -> LOGGER.warning("Failed to decrypt content with algorithm - {}", algorithm, error));
    }

    public DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        return this.decrypt(algorithm, ciphertext, null, null, null, context);
    }

    public DecryptResult decrypt(DecryptParameters decryptParameters, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decrypt(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), decryptParameters.getIv(), decryptParameters.getAdditionalAuthenticatedData(), decryptParameters.getAuthenticationTag(), context);
    }

    private DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] additionalAuthenticatedData, byte[] authenticationTag, Context context) {
        KeyOperationResult result = this.keyClient.decryptWithResponse(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeyEncryptionAlgorithm(algorithm), ciphertext, iv, additionalAuthenticatedData, authenticationTag, context).getValue();
        return new DecryptResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        return this.keyClient.signAsync(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest, context).map(result -> new SignResult(result.getResult(), algorithm, this.keyId)).doOnRequest(ignored -> LOGGER.verbose("Signing content with algorithm - {}", algorithm)).doOnSuccess(response -> LOGGER.verbose("Retrieved signed content with algorithm - {}", algorithm)).doOnError(error -> LOGGER.warning("Failed to sign content with algorithm - {}", algorithm, error));
    }

    public SignResult sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        KeyOperationResult result = this.keyClient.signWithResponse(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest, context).getValue();
        return new SignResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        return this.keyClient.verifyAsync(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest, signature, context).map(result -> new VerifyResult(result.isValue(), algorithm, this.keyId)).doOnRequest(ignored -> LOGGER.verbose("Verifying content with algorithm - {}", algorithm)).doOnSuccess(response -> LOGGER.verbose("Retrieved verified content with algorithm - {}", algorithm)).doOnError(error -> LOGGER.warning("Failed to verify content with algorithm - {}", algorithm, error));
    }

    public VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        KeyVerifyResult result = this.keyClient.verifyWithResponse(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapKeySignatureAlgorithm(algorithm), digest, signature, context).getValue();
        return new VerifyResult(result.isValue(), algorithm, this.keyId);
    }

    public Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        return this.keyClient.wrapKeyAsync(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapWrapAlgorithm(algorithm), key, null, null, null, context).map(result -> new WrapResult(result.getResult(), algorithm, this.keyId)).doOnRequest(ignored -> LOGGER.verbose("Wrapping key content with algorithm - {}", algorithm)).doOnSuccess(response -> LOGGER.verbose("Retrieved wrapped key content with algorithm - {}", algorithm)).doOnError(error -> LOGGER.warning("Failed to verify content with algorithm - {}", algorithm, error));
    }

    public WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        KeyOperationResult result = this.keyClient.wrapKeyWithResponse(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapWrapAlgorithm(algorithm), key, null, null, null, context).getValue();
        return new WrapResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        return this.keyClient.unwrapKeyAsync(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapWrapAlgorithm(algorithm), encryptedKey, null, null, null, context).map(result -> new UnwrapResult(result.getResult(), algorithm, this.keyId)).doOnRequest(ignored -> LOGGER.verbose("Unwrapping key content with algorithm - {}", algorithm)).doOnSuccess(response -> LOGGER.verbose("Retrieved unwrapped key content with algorithm - {}", algorithm)).doOnError(error -> LOGGER.warning("Failed to unwrap key content with algorithm - {}", algorithm, error));
    }

    public UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        KeyOperationResult result = this.keyClient.unwrapKeyWithResponse(this.vaultUrl, this.keyName, this.keyVersion, CryptographyUtils.mapWrapAlgorithm(algorithm), encryptedKey, null, null, null, context).getValue();
        return new UnwrapResult(result.getResult(), algorithm, this.keyId);
    }

    public Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.signAsync(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error(e);
        }
    }

    public SignResult signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.sign(algorithm, digest, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    public Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to verify cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verifyAsync(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error(e);
        }
    }

    public VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to verify cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        try {
            HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
            md.update(data);
            byte[] digest = md.digest();
            return this.verify(algorithm, digest, signature, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

