/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Base64Url;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import java.io.IOException;
import java.util.Objects;

public final class KeySignParameters
implements JsonSerializable<KeySignParameters> {
    private JsonWebKeySignatureAlgorithm algorithm;
    private Base64Url value;

    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeySignParameters setAlgorithm(JsonWebKeySignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    public KeySignParameters setValue(byte[] value) {
        this.value = value == null ? null : Base64Url.encode(CoreUtils.clone(value));
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        return jsonWriter.writeEndObject();
    }

    public static KeySignParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeySignParameters deserializedKeySignParameters = new KeySignParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alg".equals(fieldName)) {
                    deserializedKeySignParameters.algorithm = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeySignParameters.value = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeySignParameters;
        });
    }
}

