/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.options;

import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;

public final class BlockBlobStageBlockOptions {
    private final String base64BlockId;
    private final BinaryData data;
    private String leaseId;
    private byte[] contentMd5;

    public BlockBlobStageBlockOptions(String base64BlockId, BinaryData data) {
        StorageImplUtils.assertNotNull("base64BlockId must not be null", base64BlockId);
        StorageImplUtils.assertNotNull("data must not be null", data);
        StorageImplUtils.assertNotNull("data must have defined length", data.getLength());
        this.base64BlockId = base64BlockId;
        this.data = data;
    }

    public String getBase64BlockId() {
        return this.base64BlockId;
    }

    public BinaryData getData() {
        return this.data;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public BlockBlobStageBlockOptions setLeaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.contentMd5);
    }

    public BlockBlobStageBlockOptions setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone(contentMd5);
        return this;
    }
}

