/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring;

import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.ConnectionSettings;

@FunctionalInterface
interface ConnectionSettingsFilter {
    public ConnectionSettings apply(ConnectionSettings var1);

    public static ConnectionSettingsFilter allRequired(String ... settingNames) {
        return inputSettings -> {
            ConnectionSettings outputSettings = inputSettings.clone();
            for (String settingName : settingNames) {
                if (!outputSettings.hasSetting(settingName)) {
                    return null;
                }
                outputSettings.removeSetting(settingName);
            }
            return outputSettings;
        };
    }

    public static ConnectionSettingsFilter optional(String ... settingNames) {
        return inputSettings -> {
            ConnectionSettings outputSettings = inputSettings.clone();
            for (String settingName : settingNames) {
                outputSettings.removeSetting(settingName);
            }
            return outputSettings;
        };
    }

    public static ConnectionSettingsFilter atLeastOne(String ... settingNames) {
        return inputSettings -> {
            ConnectionSettings outputSettings = inputSettings.clone();
            boolean foundOne = false;
            for (String settingName : settingNames) {
                if (!outputSettings.hasSetting(settingName)) continue;
                outputSettings.removeSetting(settingName);
                foundOne = true;
            }
            return foundOne ? outputSettings : null;
        };
    }

    public static ConnectionSettingsFilter none(String ... settingNames) {
        return inputSettings -> {
            ConnectionSettings outputSettings = inputSettings.clone();
            boolean foundOne = false;
            for (String settingName : settingNames) {
                if (!outputSettings.hasSetting(settingName)) continue;
                outputSettings.removeSetting(settingName);
                foundOne = true;
            }
            return foundOne ? null : outputSettings;
        };
    }

    public static ConnectionSettingsFilter matchesAll(ConnectionSettingsFilter ... filters) {
        return inputSettings -> {
            ConnectionSettings outputSettings = inputSettings.clone();
            for (ConnectionSettingsFilter filter : filters) {
                if (outputSettings == null) break;
                outputSettings = filter.apply(outputSettings);
            }
            return outputSettings;
        };
    }

    public static ConnectionSettingsFilter matchesOne(ConnectionSettingsFilter ... filters) {
        return settings -> {
            ConnectionSettings matchResult = null;
            for (ConnectionSettingsFilter filter : filters) {
                ConnectionSettings result = filter.apply(settings.clone());
                if (result == null) continue;
                if (matchResult == null) {
                    matchResult = result;
                    continue;
                }
                return null;
            }
            return matchResult;
        };
    }

    public static ConnectionSettingsFilter matchesExactly(ConnectionSettingsFilter filter) {
        return settings -> {
            ConnectionSettings result = settings.clone();
            if ((result = filter.apply(result)) == null || !result.isEmpty()) {
                return null;
            }
            return result;
        };
    }

    public static boolean matchesSpecification(ConnectionSettings settings, ConnectionSettingsFilter ... constraints) {
        for (ConnectionSettingsFilter constraint : constraints) {
            ConnectionSettings remainingSettings = constraint.apply(settings);
            if (remainingSettings == null) {
                return false;
            }
            settings = remainingSettings;
        }
        return settings.isEmpty();
    }
}

