/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ListSharesIncludeType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ListSharesResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ServicesGetPropertiesHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentNextHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ServicesSetPropertiesHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ShareItemInternal;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ShareStorageExceptionInternal;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareTokenIntent;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureFileStorageImpl client;

    ServicesImpl(AzureFileStorageImpl client) {
        this.service = RestProxy.create(ServicesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout2) {
        return FluxUtil.withContext(context -> this.setPropertiesWithResponseAsync(shareServiceProperties, timeout2, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout2, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), shareServiceProperties, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(ShareServiceProperties shareServiceProperties, Integer timeout2) {
        return this.setPropertiesWithResponseAsync(shareServiceProperties, timeout2).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(ShareServiceProperties shareServiceProperties, Integer timeout2, Context context) {
        return this.setPropertiesWithResponseAsync(shareServiceProperties, timeout2, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout2) {
        return FluxUtil.withContext(context -> this.setPropertiesNoCustomHeadersWithResponseAsync(shareServiceProperties, timeout2, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout2, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), shareServiceProperties, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesWithResponse(ShareServiceProperties shareServiceProperties, Integer timeout2, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesSync(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), shareServiceProperties, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(ShareServiceProperties shareServiceProperties, Integer timeout2) {
        this.setPropertiesWithResponse(shareServiceProperties, timeout2, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(ShareServiceProperties shareServiceProperties, Integer timeout2, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), shareServiceProperties, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>> getPropertiesWithResponseAsync(Integer timeout2) {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponseAsync(timeout2, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>> getPropertiesWithResponseAsync(Integer timeout2, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareServiceProperties> getPropertiesAsync(Integer timeout2) {
        return this.getPropertiesWithResponseAsync(timeout2).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((ShareServiceProperties)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareServiceProperties> getPropertiesAsync(Integer timeout2, Context context) {
        return this.getPropertiesWithResponseAsync(timeout2, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((ShareServiceProperties)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout2) {
        return FluxUtil.withContext(context -> this.getPropertiesNoCustomHeadersWithResponseAsync(timeout2, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout2, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties> getPropertiesWithResponse(Integer timeout2, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.getPropertiesSync(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareServiceProperties getProperties(Integer timeout2) {
        try {
            return this.getPropertiesWithResponse(timeout2, Context.NONE).getValue();
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareServiceProperties> getPropertiesNoCustomHeadersWithResponse(Integer timeout2, Context context) {
        try {
            String restype = "service";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listSharesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<ServicesListSharesSegmentHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), (ServicesListSharesSegmentHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listSharesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<ServicesListSharesSegmentHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), (ServicesListSharesSegmentHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        return new PagedFlux<ShareItemInternal>(() -> this.listSharesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout2), nextLink -> this.listSharesSegmentNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        return new PagedFlux<ShareItemInternal>(() -> this.listSharesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout2, context), nextLink -> this.listSharesSegmentNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listSharesSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listSharesSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        return new PagedFlux<ShareItemInternal>(() -> this.listSharesSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, include, timeout2), nextLink -> this.listSharesSegmentNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        return new PagedFlux<ShareItemInternal>(() -> this.listSharesSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, include, timeout2, context), nextLink -> this.listSharesSegmentNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentSinglePage(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse> res = this.service.listSharesSegmentSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", Context.NONE);
            return new PagedResponseBase<ServicesListSharesSegmentHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentSinglePage(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse> res = this.service.listSharesSegmentSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
            return new PagedResponseBase<ServicesListSharesSegmentHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegment(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        return new PagedIterable<ShareItemInternal>(() -> this.listSharesSegmentSinglePage(prefix, marker, maxresults, include, timeout2, Context.NONE), nextLink -> this.listSharesSegmentNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegment(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        return new PagedIterable<ShareItemInternal>(() -> this.listSharesSegmentSinglePage(prefix, marker, maxresults, include, timeout2, context), nextLink -> this.listSharesSegmentNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNoCustomHeadersSinglePage(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            Response<ListSharesResponse> res = this.service.listSharesSegmentNoCustomHeadersSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", Context.NONE);
            return new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNoCustomHeadersSinglePage(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        try {
            String comp = "list";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            Response<ListSharesResponse> res = this.service.listSharesSegmentNoCustomHeadersSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout2, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
            return new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegmentNoCustomHeaders(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2) {
        return new PagedIterable<ShareItemInternal>(() -> this.listSharesSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, include, timeout2, Context.NONE), nextLink -> this.listSharesSegmentNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegmentNoCustomHeaders(String prefix, String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout2, Context context) {
        return new PagedIterable<ShareItemInternal>(() -> this.listSharesSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, include, timeout2, context), nextLink -> this.listSharesSegmentNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextSinglePageAsync(String nextLink) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listSharesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<ServicesListSharesSegmentNextHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), (ServicesListSharesSegmentNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/xml";
        return this.service.listSharesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<ServicesListSharesSegmentNextHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), (ServicesListSharesSegmentNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextNoCustomHeadersSinglePageAsync(String nextLink) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listSharesSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, Context context) {
        String accept = "application/xml";
        return this.service.listSharesSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).map(res -> new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListSharesResponse)res.getValue()).getShareItems(), ((ListSharesResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextSinglePage(String nextLink) {
        try {
            String accept = "application/xml";
            ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse> res = this.service.listSharesSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", Context.NONE);
            return new PagedResponseBase<ServicesListSharesSegmentNextHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextSinglePage(String nextLink, Context context) {
        try {
            String accept = "application/xml";
            ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse> res = this.service.listSharesSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
            return new PagedResponseBase<ServicesListSharesSegmentNextHeaders, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextNoCustomHeadersSinglePage(String nextLink) {
        try {
            String accept = "application/xml";
            Response<ListSharesResponse> res = this.service.listSharesSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", Context.NONE);
            return new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextNoCustomHeadersSinglePage(String nextLink, Context context) {
        try {
            String accept = "application/xml";
            Response<ListSharesResponse> res = this.service.listSharesSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
            return new PagedResponseBase<Object, ShareItemInternal>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageServ")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @BodyParam(value="application/xml") ShareServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @BodyParam(value="application/xml") ShareServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @BodyParam(value="application/xml") ShareServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @BodyParam(value="application/xml") ShareServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ShareServiceProperties>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties> getPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ShareServiceProperties> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse>> listSharesSegment(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ListSharesResponse>> listSharesSegmentNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse> listSharesSegmentSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ListSharesResponse> listSharesSegmentNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse>> listSharesSegmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ListSharesResponse>> listSharesSegmentNextNoCustomHeaders(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse> listSharesSegmentNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ListSharesResponse> listSharesSegmentNextNoCustomHeadersSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

