/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import java.util.Base64;

public final class FilesUploadRangeFromURLHeaders {
    private String xMsVersion;
    private String eTag;
    private byte[] xMsContentCrc64;
    private DateTimeRfc1123 lastModified;
    private String xMsRequestId;
    private Boolean xMsRequestServerEncrypted;
    private DateTimeRfc1123 date;
    private OffsetDateTime xMsFileLastWriteTime;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_CONTENT_CRC64 = HttpHeaderName.fromString("x-ms-content-crc64");
    private static final HttpHeaderName X_MS_REQUEST_SERVER_ENCRYPTED = HttpHeaderName.fromString("x-ms-request-server-encrypted");
    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME = HttpHeaderName.fromString("x-ms-file-last-write-time");

    public FilesUploadRangeFromURLHeaders(HttpHeaders rawHeaders) {
        String xMsFileLastWriteTime;
        String date;
        String lastModified;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsContentCrc64 = rawHeaders.getValue(X_MS_CONTENT_CRC64);
        if (xMsContentCrc64 != null) {
            this.xMsContentCrc64 = Base64.getDecoder().decode(xMsContentCrc64);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsRequestServerEncrypted = rawHeaders.getValue(X_MS_REQUEST_SERVER_ENCRYPTED);
        if (xMsRequestServerEncrypted != null) {
            this.xMsRequestServerEncrypted = Boolean.parseBoolean(xMsRequestServerEncrypted);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME)) != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesUploadRangeFromURLHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FilesUploadRangeFromURLHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone(this.xMsContentCrc64);
    }

    public FilesUploadRangeFromURLHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone(xMsContentCrc64);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FilesUploadRangeFromURLHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesUploadRangeFromURLHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public FilesUploadRangeFromURLHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesUploadRangeFromURLHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public FilesUploadRangeFromURLHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }
}

