/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ClearRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.FileRange;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareFileRangeList
implements XmlSerializable<ShareFileRangeList> {
    private List<FileRange> ranges = new ArrayList<FileRange>();
    private List<ClearRange> clearRanges = new ArrayList<ClearRange>();

    public List<FileRange> getRanges() {
        return this.ranges;
    }

    public ShareFileRangeList setRanges(List<FileRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public List<ClearRange> getClearRanges() {
        return this.clearRanges;
    }

    public ShareFileRangeList setClearRanges(List<ClearRange> clearRanges) {
        this.clearRanges = clearRanges;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Ranges" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.ranges != null) {
            for (FileRange fileRange : this.ranges) {
                xmlWriter.writeXml(fileRange, "Range");
            }
        }
        if (this.clearRanges != null) {
            for (ClearRange clearRange : this.clearRanges) {
                xmlWriter.writeXml(clearRange, "ClearRange");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static ShareFileRangeList fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareFileRangeList.fromXml(xmlReader, null);
    }

    public static ShareFileRangeList fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Ranges" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareFileRangeList deserializedShareFileRangeList = new ShareFileRangeList();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Range".equals(elementName.getLocalPart())) {
                    deserializedShareFileRangeList.ranges.add(FileRange.fromXml(reader, "Range"));
                    continue;
                }
                if ("ClearRange".equals(elementName.getLocalPart())) {
                    deserializedShareFileRangeList.clearRanges.add(ClearRange.fromXml(reader, "ClearRange"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareFileRangeList;
        });
    }
}

