/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import com.dataiku.dss.shadelibazure.com.azure.storage.common.ParallelTransferOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareRequestConditions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ShareFileUploadOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final Long length;
    private Long offset;
    private ParallelTransferOptions parallelTransferOptions;
    private ShareRequestConditions requestConditions;

    public ShareFileUploadOptions(Flux<ByteBuffer> dataFlux) {
        StorageImplUtils.assertNotNull("dataFlux", dataFlux);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = null;
    }

    @Deprecated
    public ShareFileUploadOptions(InputStream dataStream, long length) {
        StorageImplUtils.assertNotNull("dataStream", length);
        StorageImplUtils.assertInBounds("length", length, 0L, Long.MAX_VALUE);
        this.dataStream = dataStream;
        this.length = length;
        this.dataFlux = null;
    }

    public ShareFileUploadOptions(InputStream dataStream) {
        StorageImplUtils.assertNotNull("dataStream", dataStream);
        this.dataStream = dataStream;
        this.dataFlux = null;
        this.length = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public Long getLength() {
        return this.length;
    }

    public Long getOffset() {
        return this.offset;
    }

    public ShareFileUploadOptions setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public ParallelTransferOptions getParallelTransferOptions() {
        return this.parallelTransferOptions;
    }

    public ShareFileUploadOptions setParallelTransferOptions(ParallelTransferOptions parallelTransferOptions) {
        this.parallelTransferOptions = parallelTransferOptions;
        return this;
    }

    public ShareRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public ShareFileUploadOptions setRequestConditions(ShareRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }
}

