/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.com.google.gson.JsonArray;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonObject;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonParseException;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonPrimitive;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseCollectionResponse;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.ILogger;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.DefaultSerializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.IJsonBackedObject;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class CollectionResponseDeserializer {
    private static DefaultSerializer serializer;

    private CollectionResponseDeserializer() {
    }

    @Nullable
    public static <T1> BaseCollectionResponse<T1> deserialize(@Nonnull JsonElement json, @Nonnull Type typeOfT, @Nonnull ILogger logger) throws JsonParseException {
        Class<?> baseEntityClass;
        if (json == null || !json.isJsonObject() || !typeOfT.getClass().equals(Class.class)) {
            return null;
        }
        serializer = new DefaultSerializer(logger);
        JsonObject jsonAsObject = json.getAsJsonObject();
        JsonArray sourceArray = jsonAsObject.get("value").getAsJsonArray();
        ArrayList list = new ArrayList(sourceArray.size());
        Class responseClass = (Class)typeOfT;
        String genericResponseName = responseClass.getGenericSuperclass().toString();
        int indexOfGenericMarker = genericResponseName.indexOf(60);
        String baseEntityClassCanonicalName = genericResponseName.substring(indexOfGenericMarker + 1, genericResponseName.length() - 1);
        try {
            baseEntityClass = Class.forName(baseEntityClassCanonicalName);
        }
        catch (ClassNotFoundException ex) {
            baseEntityClass = null;
            logger.logDebug("could not find class" + baseEntityClassCanonicalName);
        }
        try {
            for (JsonElement sourceElement : sourceArray) {
                if (sourceElement.isJsonObject()) {
                    JsonObject sourceObject = sourceElement.getAsJsonObject();
                    Object targetObject = serializer.deserializeObject(sourceObject, baseEntityClass);
                    ((IJsonBackedObject)targetObject).setRawObject(serializer, sourceObject);
                    list.add(targetObject);
                    continue;
                }
                if (!sourceElement.isJsonPrimitive()) continue;
                JsonPrimitive primitiveValue = sourceElement.getAsJsonPrimitive();
                if (primitiveValue.isString()) {
                    list.add(primitiveValue.getAsString());
                    continue;
                }
                if (primitiveValue.isBoolean()) {
                    list.add(primitiveValue.getAsBoolean());
                    continue;
                }
                if (!primitiveValue.isNumber()) continue;
                list.add(primitiveValue.getAsLong());
            }
            BaseCollectionResponse response = (BaseCollectionResponse)responseClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            response.value = list;
            JsonElement potentialNextLink = jsonAsObject.get("@odata.nextLink");
            if (potentialNextLink != null) {
                response.nextLink = potentialNextLink.getAsString();
            }
            response.setRawObject(serializer, jsonAsObject);
            return response;
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            logger.logError("Could not instanciate type during deserialization", ex);
        }
        catch (IllegalAccessException ex) {
            logger.logError("Unable to set field value during deserialization", ex);
        }
        return null;
    }
}

