/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufHolder;
import com.dataiku.dss.shadelibazure.io.netty.buffer.Unpooled;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInboundHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.CombinedChannelDuplexHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.ByteToMessageCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.ByteToMessageDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.FullHttpMessage;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaderNames;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpMessage;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpObject;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpUtil;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCountUtil;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCounted;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyOutbound;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyPipeline;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.AbortedException;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.HttpInfos;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageArgProviderFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent;
    static final int READY = 0;
    static final int HEADERS_SENT = 1;
    static final int BODY_SENT = 2;
    final HttpMessageLogFactory httpMessageLogFactory;
    static final AtomicIntegerFieldUpdater<HttpOperations> HTTP_STATE = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ByteBuf bb = ((ByteBufHolder)msg).content();
                ctx.fireChannelRead(bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });
    static final Logger log = Loggers.getLogger(HttpOperations.class);
    static final Pattern SCHEME_PATTERN = Pattern.compile("^(https?|wss?)://.*$");

    protected HttpOperations(HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(replaced);
        this.httpMessageLogFactory = replaced.httpMessageLogFactory;
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Connection connection, ConnectionObserver listener, HttpMessageLogFactory httpMessageLogFactory) {
        super(connection, listener);
        this.httpMessageLogFactory = httpMessageLogFactory;
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent != 0;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    @Override
    public String requestId() {
        return this.asShortText();
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source2) {
        if (!this.channel().isActive()) {
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (source2 instanceof Mono) {
            return new PostHeadersNettyOutbound(((Mono)source2).flatMap(b -> {
                if (this.markSentHeaderAndBody(b)) {
                    HttpMessage msg = this.prepareHttpMessage((ByteBuf)b);
                    try {
                        this.afterMarkSentHeaders();
                    }
                    catch (RuntimeException e) {
                        ReferenceCountUtil.release(b);
                        return Mono.error(e);
                    }
                    return FutureMono.from(this.channel().writeAndFlush(msg));
                }
                return FutureMono.from(this.channel().writeAndFlush(b));
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release), this, null);
        }
        return super.send(source2);
    }

    @Override
    public NettyOutbound sendObject(Object message) {
        if (!this.channel().isActive()) {
            ReactorNetty.safeRelease(message);
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (!(message instanceof ByteBuf)) {
            return super.sendObject(message);
        }
        ByteBuf b = (ByteBuf)message;
        return new PostHeadersNettyOutbound(FutureMono.deferFuture(() -> {
            if (this.markSentHeaderAndBody(b)) {
                HttpMessage msg = this.prepareHttpMessage(b);
                this.afterMarkSentHeaders();
                return this.channel().writeAndFlush(msg);
            }
            return this.channel().writeAndFlush(b);
        }), this, b);
    }

    @Override
    public Mono<Void> then() {
        if (!this.channel().isActive()) {
            return Mono.error(AbortedException.beforeSend());
        }
        if (this.hasSentHeaders()) {
            return Mono.empty();
        }
        return FutureMono.deferFuture(() -> {
            if (this.markSentHeaders(this.outboundHttpMessage())) {
                HttpMessage msg;
                if (HttpUtil.isContentLengthSet(this.outboundHttpMessage())) {
                    this.outboundHttpMessage().headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
                    if (HttpUtil.getContentLength(this.outboundHttpMessage(), 0) == 0) {
                        this.markSentBody();
                        msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
                    } else {
                        msg = this.outboundHttpMessage();
                    }
                } else if (this.isContentAlwaysEmpty()) {
                    this.markSentBody();
                    msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
                } else {
                    msg = this.outboundHttpMessage();
                }
                try {
                    this.afterMarkSentHeaders();
                }
                catch (RuntimeException e) {
                    ReferenceCountUtil.release(msg);
                    throw e;
                }
                return this.channel().writeAndFlush(msg).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.onHeadersSent()));
            }
            return this.channel().newSucceededFuture();
        });
    }

    @Override
    protected String asDebugLogMessage(Object o) {
        return o instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(o)) : o.toString();
    }

    protected HttpMessageLogFactory httpMessageLogFactory() {
        return this.httpMessageLogFactory;
    }

    protected abstract void beforeMarkSentHeaders();

    protected abstract void afterMarkSentHeaders();

    protected abstract boolean isContentAlwaysEmpty();

    protected abstract void onHeadersSent();

    protected abstract HttpMessage newFullBodyMessage(ByteBuf var1);

    @Override
    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked(this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet(this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt(HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet(this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove(HttpHeaderNames.CONTENT_LENGTH).remove(HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked(this.outboundHttpMessage(), true);
        }
        return super.sendFile(file, position, count);
    }

    @Override
    public String toString() {
        if (this.isWebsocket()) {
            return "ws{uri=" + this.fullPath() + ", connection=" + this.connection() + "}";
        }
        return this.method().name() + "{uri=" + this.fullPath() + ", connection=" + this.connection() + "}";
    }

    @Override
    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor(this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(Connection c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, HTTP_EXTRACTOR);
            if (c.isPersistent()) {
                c.onTerminate().subscribe(null, null, () -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markSentHeaders(Object ... objectsToRelease) {
        try {
            if (!this.hasSentHeaders()) {
                this.beforeMarkSentHeaders();
            }
        }
        catch (RuntimeException e) {
            for (Object o : objectsToRelease) {
                try {
                    ReferenceCountUtil.release(o);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        return HTTP_STATE.compareAndSet(this, 0, 1);
    }

    protected final boolean markSentBody() {
        return HTTP_STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean hasSentBody() {
        return this.statusAndHeadersSent == 2;
    }

    protected final boolean markSentHeaderAndBody(Object ... objectsToRelease) {
        try {
            if (!this.hasSentHeaders()) {
                this.beforeMarkSentHeaders();
            }
        }
        catch (RuntimeException e) {
            for (Object o : objectsToRelease) {
                try {
                    ReferenceCountUtil.release(o);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        return HTTP_STATE.compareAndSet(this, 0, 2);
    }

    @Override
    protected final String initShortId() {
        if (this.connection() instanceof AtomicLong) {
            return this.channel().id().asShortText() + '-' + ((AtomicLong)((Object)this.connection())).incrementAndGet();
        }
        return super.initShortId();
    }

    public static String resolvePath(String uri) {
        Objects.requireNonNull(uri, "uri");
        String tempUri = uri;
        int index = tempUri.indexOf(63);
        if (index > -1) {
            tempUri = tempUri.substring(0, index);
        }
        if ((index = tempUri.indexOf(35)) > -1) {
            tempUri = tempUri.substring(0, index);
        }
        if (tempUri.isEmpty()) {
            return tempUri;
        }
        if (tempUri.charAt(0) == '/') {
            if (tempUri.length() == 1) {
                return tempUri;
            }
            tempUri = "http://localhost:8080" + tempUri;
        } else if (!SCHEME_PATTERN.matcher(tempUri).matches()) {
            tempUri = "http://" + tempUri;
        }
        return URI.create(tempUri).getPath();
    }

    protected abstract HttpMessage outboundHttpMessage();

    HttpMessage prepareHttpMessage(ByteBuf buffer) {
        HttpMessage msg;
        if (HttpUtil.getContentLength(this.outboundHttpMessage(), -1) == 0 || this.isContentAlwaysEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Dropped HTTP content, since response has 1. [Content-Length: 0] or 2. there must be no content: {}"), buffer);
            }
            buffer.release();
            msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
        } else {
            msg = this.newFullBodyMessage(buffer);
        }
        return msg;
    }

    protected static final class PostHeadersNettyOutbound
    extends AtomicBoolean
    implements NettyOutbound,
    Consumer<Throwable>,
    Runnable {
        final Mono<Void> source;
        final HttpOperations<?, ?> parent;
        final ByteBuf msg;

        public PostHeadersNettyOutbound(Mono<Void> source2, HttpOperations<?, ?> parent, @Nullable ByteBuf msg) {
            this.msg = msg;
            this.source = msg != null ? source2.doOnError(this).doOnCancel(this) : source2;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.msg != null && this.msg.refCnt() > 0 && this.compareAndSet(false, true)) {
                this.msg.release();
            }
        }

        @Override
        public void accept(Throwable throwable) {
            if (this.msg != null && this.msg.refCnt() > 0 && this.compareAndSet(false, true)) {
                this.msg.release();
            }
        }

        @Override
        public Mono<Void> then() {
            return this.source;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.parent.alloc();
        }

        @Override
        public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
            return this.parent.send(dataStream, predicate);
        }

        @Override
        public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
            return this.parent.sendObject(dataStream, predicate);
        }

        @Override
        public NettyOutbound sendObject(Object message) {
            return this.parent.sendObject(message);
        }

        @Override
        public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
            return this.parent.sendUsing(sourceInput, mappedInput, sourceCleanup);
        }

        @Override
        public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
            return this.parent.withConnection(withConnection);
        }
    }
}

