/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.tcp;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.DecoderException;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.AbstractSniHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.SslHandler;
import com.dataiku.dss.shadelibazure.io.netty.util.AsyncMapping;
import com.dataiku.dss.shadelibazure.io.netty.util.DomainWildcardMappingBuilder;
import com.dataiku.dss.shadelibazure.io.netty.util.Mapping;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCountUtil;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Promise;
import com.dataiku.dss.shadelibazure.io.netty.util.internal.PlatformDependent;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.SslProvider;
import java.util.Map;

final class SniProvider {
    final long handshakeTimeoutMillis;
    final AsyncMapping<String, SslProvider> mappings;

    void addSniHandler(Channel channel, boolean sslDebug) {
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.nonSslRedirectDetector") != null) {
            pipeline.addAfter("com.dataiku.dss.shadelibazure.reactor.left.nonSslRedirectDetector", "com.dataiku.dss.shadelibazure.reactor.left.sslHandler", this.newSniHandler());
        } else {
            pipeline.addFirst("com.dataiku.dss.shadelibazure.reactor.left.sslHandler", (ChannelHandler)this.newSniHandler());
        }
        SslProvider.addSslReadHandler(pipeline, sslDebug);
    }

    SniProvider(AsyncMapping<String, SslProvider> mappings, long handshakeTimeoutMillis) {
        this.mappings = mappings;
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    SniProvider(Map<String, SslProvider> confPerDomainName, SslProvider defaultSslProvider) {
        DomainWildcardMappingBuilder<SslProvider> mappingsSslProviderBuilder = new DomainWildcardMappingBuilder<SslProvider>(defaultSslProvider);
        confPerDomainName.forEach(mappingsSslProviderBuilder::add);
        this.mappings = new AsyncMappingAdapter(mappingsSslProviderBuilder.build());
        this.handshakeTimeoutMillis = defaultSslProvider.handshakeTimeoutMillis;
    }

    SniHandler newSniHandler() {
        return new SniHandler(this.mappings, this.handshakeTimeoutMillis);
    }

    static final class SniHandler
    extends AbstractSniHandler<SslProvider> {
        final AsyncMapping<String, SslProvider> mappings;

        SniHandler(AsyncMapping<String, SslProvider> mappings, long handshakeTimeoutMillis) {
            super(handshakeTimeoutMillis);
            this.mappings = mappings;
        }

        @Override
        protected Future<SslProvider> lookup(ChannelHandlerContext ctx, String hostname) {
            return this.mappings.map(hostname, ctx.executor().newPromise());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslProvider> future) {
            if (!future.isSuccess()) {
                Throwable cause = future.cause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new DecoderException("failed to get the SslContext for " + hostname, cause);
            }
            SslProvider sslProvider = future.getNow();
            SslHandler sslHandler = null;
            try {
                sslHandler = sslProvider.getSslContext().newHandler(ctx.alloc());
                sslProvider.configure(sslHandler);
                ctx.pipeline().replace(this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
                sslHandler = null;
            }
            catch (Throwable cause) {
                PlatformDependent.throwException(cause);
            }
            finally {
                if (sslHandler != null) {
                    ReferenceCountUtil.safeRelease(sslHandler.engine());
                }
            }
        }
    }

    static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslProvider> {
        final Mapping<String, SslProvider> mapping;

        AsyncMappingAdapter(Mapping<String, SslProvider> mapping) {
            this.mapping = mapping;
        }

        @Override
        public Future<SslProvider> map(String input, Promise<SslProvider> promise) {
            try {
                return promise.setSuccess(this.mapping.map(input));
            }
            catch (Throwable cause) {
                return promise.setFailure(cause);
            }
        }
    }
}

