/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Snapshot;
import io.delta.kernel.Table;
import io.delta.kernel.TransactionBuilder;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.CheckpointAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaHistoryManager;
import io.delta.kernel.internal.DeltaLogActionUtils;
import io.delta.kernel.internal.TableFeatures;
import io.delta.kernel.internal.TransactionBuilderImpl;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.snapshot.SnapshotManager;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableImpl
implements Table {
    private static final Logger logger = LoggerFactory.getLogger(TableImpl.class);
    private final SnapshotManager snapshotManager;
    private final String tablePath;
    private final Clock clock;

    public static Table forPath(Engine engine, String string) {
        return TableImpl.forPath(engine, string, System::currentTimeMillis);
    }

    public static Table forPath(Engine engine, String string, Clock clock) {
        String string2;
        try {
            string2 = DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().resolvePath(string), "Resolving path %s", string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return new TableImpl(string2, clock);
    }

    public TableImpl(String string, Clock clock) {
        this.tablePath = string;
        Path path = new Path(string);
        Path path2 = new Path(path, "_delta_log");
        this.snapshotManager = new SnapshotManager(path2, path);
        this.clock = clock;
    }

    @Override
    public String getPath(Engine engine) {
        return this.tablePath;
    }

    @Override
    public Snapshot getLatestSnapshot(Engine engine) throws TableNotFoundException {
        return this.snapshotManager.buildLatestSnapshot(engine);
    }

    @Override
    public Snapshot getSnapshotAsOfVersion(Engine engine, long l) throws TableNotFoundException {
        return this.snapshotManager.getSnapshotAt(engine, l);
    }

    @Override
    public Snapshot getSnapshotAsOfTimestamp(Engine engine, long l) throws TableNotFoundException {
        return this.snapshotManager.getSnapshotForTimestamp(engine, l);
    }

    @Override
    public void checkpoint(Engine engine, long l) throws TableNotFoundException, CheckpointAlreadyExistsException, IOException {
        this.snapshotManager.checkpoint(engine, this.clock, l);
    }

    @Override
    public TransactionBuilder createTransactionBuilder(Engine engine, String string, Operation operation) {
        return new TransactionBuilderImpl(this, string, operation);
    }

    public Clock getClock() {
        return this.clock;
    }

    public CloseableIterator<ColumnarBatch> getChanges(Engine engine, long l, long l2, Set<DeltaLogActionUtils.DeltaAction> set) {
        HashSet<DeltaLogActionUtils.DeltaAction> hashSet = new HashSet<DeltaLogActionUtils.DeltaAction>(set);
        hashSet.add(DeltaLogActionUtils.DeltaAction.PROTOCOL);
        boolean bl = !set.contains((Object)DeltaLogActionUtils.DeltaAction.PROTOCOL);
        return this.getRawChanges(engine, l, l2, hashSet).map(columnarBatch -> {
            int n = columnarBatch.getSchema().indexOf("protocol");
            ColumnVector columnVector = columnarBatch.getColumnVector(n);
            for (int i = 0; i < columnVector.getSize(); ++i) {
                if (columnVector.isNullAt(i)) continue;
                Protocol protocol = Protocol.fromColumnVector(columnVector, i);
                TableFeatures.validateReadSupportedTable(protocol, this.getDataPath().toString(), Optional.empty());
            }
            if (bl) {
                return columnarBatch.withDeletedColumnAt(n);
            }
            return columnarBatch;
        });
    }

    protected Path getDataPath() {
        return new Path(this.tablePath);
    }

    protected Path getLogPath() {
        return new Path(this.tablePath, "_delta_log");
    }

    public long getVersionBeforeOrAtTimestamp(Engine engine, long l) {
        return DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.getLogPath(), l, false, true, false).getVersion();
    }

    public long getVersionAtOrAfterTimestamp(Engine engine, long l) {
        DeltaHistoryManager.Commit commit = DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.getLogPath(), l, false, false, true);
        if (commit.getTimestamp() >= l) {
            return commit.getVersion();
        }
        return commit.getVersion() + 1L;
    }

    private CloseableIterator<ColumnarBatch> getRawChanges(Engine engine, long l, long l2, Set<DeltaLogActionUtils.DeltaAction> set) {
        logger.info("{}: Getting the commit files for versions [{}, {}]", new Object[]{this.tablePath, l, l2});
        List<FileStatus> list = DeltaLogActionUtils.getCommitFilesForVersionRange(engine, new Path(this.tablePath), l, l2);
        StructType structType = new StructType(set.stream().map(deltaAction -> new StructField(deltaAction.colName, deltaAction.schema, true)).collect(Collectors.toList()));
        logger.info("{}: Reading the commit files with readSchema {}", (Object)this.tablePath, (Object)structType);
        return DeltaLogActionUtils.readCommitFiles(engine, list, structType);
    }
}

