/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.Globbing;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.text.Normalizer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PathUtils {
    static Pattern multipleSlashes = Pattern.compile("//+");

    public static String makeLeadingNoTrailing(String prefix) {
        Object path;
        Object object = path = prefix == null ? "" : prefix;
        while (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        assert (PathUtils.isLNT((String)path));
        return path;
    }

    public static String makeNotLeadingNoTrailing(String prefix) {
        String path;
        String string = path = prefix == null ? "" : prefix;
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        assert (PathUtils.isNLNT(path));
        return path;
    }

    public static String makeTrailingNoLeading(String prefix) {
        Object path;
        Object object = path = prefix == null ? "" : prefix;
        while (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        assert (PathUtils.isTNL((String)path));
        return path;
    }

    public static boolean isLNT(String path) {
        return "/".equals(path) || path.startsWith("/") && !path.endsWith("/");
    }

    public static boolean isTNL(String path) {
        return "/".equals(path) || path.endsWith("/") && !path.startsWith("/");
    }

    public static boolean isNLNT(String path) {
        return !path.startsWith("/") && !path.endsWith("/");
    }

    public static String concatLNT(String ... chunks) {
        Object concat = "";
        for (String chunk : chunks) {
            concat = (String)concat + PathUtils.makeLeadingNoTrailing(chunk);
        }
        while (((String)concat).contains("//")) {
            concat = StringUtils.replace((String)concat, (String)"//", (String)"/");
        }
        concat = PathUtils.makeLeadingNoTrailing((String)concat);
        return concat;
    }

    public static String stripLeadingSlash(String prefix) {
        if (prefix.startsWith("/")) {
            return prefix.substring(1);
        }
        return prefix;
    }

    public static String stripTrailingSlash(String prefix) {
        if (prefix.endsWith("/")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static void ensurePathStaysWithinRoot(String path) throws DKUSecurityException {
        String canonicalPath;
        if (path != null && (canonicalPath = PathUtils.makeNotLeadingNoTrailing(PathUtils.canonical(path))).startsWith("..")) {
            throw new DKUSecurityException("Forbidden .. segment in '" + path + "'");
        }
    }

    public static String canonical(String path) {
        String[] segments = path.split("/", 0);
        ArrayDeque<String> res = new ArrayDeque<String>(segments.length);
        String[] stringArray = segments;
        int n = stringArray.length;
        block9: for (int i = 0; i < n; ++i) {
            String d;
            switch (d = stringArray[i]) {
                case "": 
                case ".": {
                    continue block9;
                }
                case "..": {
                    if (res.isEmpty() || ((String)res.peek()).equals("..")) {
                        res.push(d);
                        continue block9;
                    }
                    res.pop();
                    continue block9;
                }
                default: {
                    res.push(d);
                }
            }
        }
        Iterator parts = res.descendingIterator();
        StringBuilder sb = new StringBuilder();
        if (path.startsWith("/")) {
            sb.append('/');
        }
        while (parts.hasNext()) {
            sb.append((String)parts.next());
            if (!parts.hasNext()) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    public static String slashes(@Nullable String prefix, @Nullable Boolean leading, @Nullable Boolean trailing, boolean collapse, @Nullable String empty) {
        Object source = prefix;
        if (source == null || ((String)source).isEmpty()) {
            return empty;
        }
        if (leading != null) {
            if (!leading.booleanValue()) {
                boolean leaveLastSlash;
                boolean bl = leaveLastSlash = trailing != null && trailing != false;
                while (((String)source).startsWith("/") && (!leaveLastSlash || ((String)source).length() > 1)) {
                    source = ((String)source).substring(1);
                }
            } else if (!((String)source).startsWith("/")) {
                source = "/" + (String)source;
            }
        }
        if (trailing != null) {
            if (!trailing.booleanValue()) {
                boolean leaveFirstSlash;
                boolean bl = leaveFirstSlash = leading != null && leading != false;
                while (((String)source).endsWith("/") && (!leaveFirstSlash || ((String)source).length() > 1)) {
                    source = ((String)source).substring(0, ((String)source).length() - 1);
                }
            } else if (!((String)source).endsWith("/")) {
                source = (String)source + "/";
            }
        }
        if (collapse) {
            source = multipleSlashes.matcher((CharSequence)source).replaceAll("/");
        }
        return ((String)source).isEmpty() ? empty : source;
    }

    public static String getParent(String path) {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("Cannot get the parent path of the empty path");
        }
        String truncatedPath = path;
        while (truncatedPath.length() > 0 && truncatedPath.charAt(truncatedPath.length() - 1) == '/') {
            truncatedPath = truncatedPath.substring(0, truncatedPath.length() - 1);
        }
        if (StringUtils.isBlank((String)truncatedPath)) {
            throw new IllegalArgumentException("Cannot get the parent path of the root path");
        }
        int lastSlash = truncatedPath.lastIndexOf(47);
        if (lastSlash < 0) {
            return "";
        }
        return truncatedPath.substring(0, lastSlash);
    }

    public static Pair<String, String> splitBasename(String path) {
        if (StringUtils.isBlank((String)path)) {
            return new Pair<String, String>("", "");
        }
        boolean leading = false;
        String truncatedPath = path;
        while (truncatedPath.length() > 0 && truncatedPath.charAt(0) == '/') {
            leading = true;
            truncatedPath = truncatedPath.substring(1);
        }
        boolean trailing = false;
        while (truncatedPath.length() > 0 && truncatedPath.charAt(truncatedPath.length() - 1) == '/') {
            trailing = true;
            truncatedPath = truncatedPath.substring(0, truncatedPath.length() - 1);
        }
        if (truncatedPath.isEmpty()) {
            return new Pair<String, String>(leading ? "/" : "", "");
        }
        if (trailing) {
            return new Pair<CallSite, String>((CallSite)((Object)((leading ? "/" : "") + truncatedPath)), "");
        }
        int lastSlash = truncatedPath.lastIndexOf(47);
        if (lastSlash < 0) {
            return new Pair<String, String>(leading ? "/" : "", truncatedPath);
        }
        return new Pair<CallSite, String>((CallSite)((Object)((leading ? "/" : "") + truncatedPath.substring(0, lastSlash))), truncatedPath.substring(lastSlash + 1));
    }

    public static Pair<String, String> splitGlobbing(String path) {
        int i;
        if (StringUtils.isBlank((String)path)) {
            return new Pair<String, Object>("", null);
        }
        boolean leading = false;
        String truncatedPath = path;
        while (truncatedPath.length() > 0 && truncatedPath.charAt(0) == '/') {
            leading = true;
            truncatedPath = truncatedPath.substring(1);
        }
        boolean trailing = false;
        while (truncatedPath.length() > 0 && truncatedPath.charAt(truncatedPath.length() - 1) == '/') {
            trailing = true;
            truncatedPath = truncatedPath.substring(0, truncatedPath.length() - 1);
        }
        Object[] elts = PathUtils.canonical(truncatedPath).split("/+");
        if (elts.length == 0) {
            return new Pair<String, String>(leading ? "/" : "", "");
        }
        int firstGlobIndex = -1;
        for (int i2 = 0; i2 < elts.length; ++i2) {
            if (!Globbing.hasGlobbing(elts[i2])) continue;
            firstGlobIndex = i2;
            break;
        }
        if (firstGlobIndex < 0) {
            return new Pair<CallSite, Object>((CallSite)((Object)((leading ? "/" : "") + Joiner.on((String)"/").join(elts) + (trailing ? "/" : ""))), null);
        }
        ArrayList notGlobbed = Lists.newArrayList();
        ArrayList globbed = Lists.newArrayList();
        for (i = 0; i < firstGlobIndex; ++i) {
            notGlobbed.add(elts[i]);
        }
        for (i = firstGlobIndex; i < elts.length; ++i) {
            globbed.add(elts[i]);
        }
        return new Pair<CallSite, CallSite>((CallSite)((Object)((leading ? "/" : "") + Joiner.on((String)"/").join((Iterable)notGlobbed))), (CallSite)((Object)(Joiner.on((String)"/").join((Iterable)globbed) + (trailing ? "/" : ""))));
    }

    public static String computeDirectoryToMoveNewPath(String d1, String d2) {
        return PathUtils.concatLNT(d2, (String)PathUtils.splitBasename((String)d1).second);
    }

    public static String getLastPathSegment(String d1) {
        d1 = PathUtils.stripTrailingSlash(d1);
        String[] segments = d1.split("/");
        return segments[segments.length - 1];
    }

    public static String getSmartExtension(String fileName) {
        Pattern extensionPattern = Pattern.compile("\\.(\\w{1,8}(?:\\.gz)?)$");
        Matcher matcher = extensionPattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("File '" + fileName + "' does not have extension or extension is too long (must be less or equal to 8 characters)");
    }

    public static String slugify(String name) {
        name = Normalizer.normalize(name, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        name = name.replaceAll("\\W+", "-");
        return name.toLowerCase();
    }

    public static class FilenameInfo {
        public String name;
        public String extension;

        public FilenameInfo(String filename) {
            if (filename == null) {
                throw new IllegalArgumentException("Cannot build FileNameInfo from null filename");
            }
            this.extension = PathUtils.getSmartExtension(filename);
            this.name = filename.substring(0, filename.length() - (this.extension.length() + 1));
        }
    }
}

