/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.ooxml;

import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.ooxml.OoXmlStrictConverterUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DateUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.XMLHelper;
import com.dataiku.dss.shadelibpoi.org.slf4j.Logger;
import com.dataiku.dss.shadelibpoi.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class OoXmlStrictConverter
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OoXmlStrictConverter.class);
    private static final QName CONFORMANCE = new QName("conformance");
    private static final Properties mappings = OoXmlStrictConverterUtils.readMappings();
    private static XMLEventFactory XEF;
    private static XMLInputFactory XIF;
    private static XMLOutputFactory XOF;
    private final XMLEventWriter xew;
    private final XMLEventReader xer;
    private int depth = 0;
    private boolean inDateCell;
    private boolean inDateValue;

    public OoXmlStrictConverter(InputStream is, OutputStream os) throws XMLStreamException {
        this.xer = OoXmlStrictConverter.getXmlInputFactory().createXMLEventReader(is);
        this.xew = OoXmlStrictConverter.getXmlOutputFactory().createXMLEventWriter(os);
    }

    public boolean convertNextElement() throws XMLStreamException {
        if (!this.xer.hasNext()) {
            return false;
        }
        XMLEvent xe = this.xer.nextEvent();
        if (xe.isStartElement()) {
            this.xew.add(this.convertDateStartElement(OoXmlStrictConverter.convertStartElement(xe.asStartElement(), this.depth == 0)));
            ++this.depth;
        } else if (xe.isEndElement()) {
            this.xew.add(this.updateDateFlagsOnEndElement(OoXmlStrictConverter.convertEndElement(xe.asEndElement())));
            --this.depth;
        } else if (this.inDateValue) {
            this.xew.add(this.convertDateValueToNumeric(xe));
        } else {
            this.xew.add(xe);
        }
        this.xew.flush();
        return true;
    }

    private XMLEvent convertDateValueToNumeric(XMLEvent xe) {
        if (!xe.isCharacters()) {
            return xe;
        }
        Date date = DateUtil.parseYYYYMMDDDate(xe.asCharacters().getData());
        double excelDate = DateUtil.getExcelDate(date);
        return OoXmlStrictConverter.getXmlEventFactory().createCharacters(Double.toString(excelDate));
    }

    private EndElement updateDateFlagsOnEndElement(EndElement endElement) {
        if (this.inDateValue) {
            if ("v".equals(endElement.getName().getLocalPart())) {
                this.inDateValue = false;
            }
            return endElement;
        }
        if (this.inDateCell) {
            if (this.isCell(endElement.getName())) {
                this.inDateCell = false;
            }
            return endElement;
        }
        return endElement;
    }

    private StartElement convertDateStartElement(StartElement startElement) {
        if (this.inDateCell) {
            if ("v".equals(startElement.getName().getLocalPart())) {
                this.inDateValue = true;
            }
            return startElement;
        }
        if (!this.isDateCell(startElement)) {
            return startElement;
        }
        this.inDateCell = true;
        return OoXmlStrictConverter.getXmlEventFactory().createStartElement(startElement.getName(), this.changeTypeAttributeToNumeric(startElement.getAttributes()), startElement.getNamespaces());
    }

    private Iterator<? extends Attribute> changeTypeAttributeToNumeric(Iterator<Attribute> attributes) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!"t".equals(attribute.getName().getLocalPart())) {
                result.add(attribute);
                continue;
            }
            result.add(OoXmlStrictConverter.getXmlEventFactory().createAttribute(attribute.getName(), "n"));
        }
        return Collections.unmodifiableList(result).iterator();
    }

    private boolean isDateCell(StartElement startElement) {
        if (!this.isCell(startElement.getName())) {
            return false;
        }
        Attribute typeAttribute = startElement.getAttributeByName(QName.valueOf("t"));
        if (typeAttribute == null) {
            return false;
        }
        return "d".equals(typeAttribute.getValue());
    }

    private boolean isCell(QName elementName) {
        return "c".equals(elementName.getLocalPart());
    }

    @Override
    public void close() throws XMLStreamException {
        this.xer.close();
        this.xew.close();
    }

    private static StartElement convertStartElement(StartElement startElement, boolean root) {
        return OoXmlStrictConverter.getXmlEventFactory().createStartElement(OoXmlStrictConverter.updateQName(startElement.getName()), OoXmlStrictConverter.processAttributes(startElement.getAttributes(), startElement.getName().getNamespaceURI(), root), OoXmlStrictConverter.processNamespaces(startElement.getNamespaces()));
    }

    private static EndElement convertEndElement(EndElement endElement) {
        return OoXmlStrictConverter.getXmlEventFactory().createEndElement(OoXmlStrictConverter.updateQName(endElement.getName()), OoXmlStrictConverter.processNamespaces(endElement.getNamespaces()));
    }

    private static QName updateQName(QName qn) {
        String mappedUri;
        String namespaceUri = qn.getNamespaceURI();
        if (OoXmlStrictConverterUtils.isNotBlank(namespaceUri) && (mappedUri = mappings.getProperty(namespaceUri)) != null) {
            qn = OoXmlStrictConverterUtils.isBlank(qn.getPrefix()) ? new QName(mappedUri, qn.getLocalPart()) : new QName(mappedUri, qn.getLocalPart(), qn.getPrefix());
        }
        return qn;
    }

    private static Iterator<Attribute> processAttributes(Iterator<Attribute> iter, String elementNamespaceUri, boolean rootElement) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        while (iter.hasNext()) {
            Attribute att = iter.next();
            QName qn = OoXmlStrictConverter.updateQName(att.getName());
            if (rootElement && mappings.containsKey(elementNamespaceUri) && att.getName().equals(CONFORMANCE)) continue;
            String newValue = att.getValue();
            for (String key : mappings.stringPropertyNames()) {
                if (!att.getValue().startsWith(key)) continue;
                newValue = att.getValue().replace(key, mappings.getProperty(key));
                break;
            }
            list.add(OoXmlStrictConverter.getXmlEventFactory().createAttribute(qn, newValue));
        }
        return Collections.unmodifiableList(list).iterator();
    }

    private static Iterator<Namespace> processNamespaces(Iterator<Namespace> iter) {
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        while (iter.hasNext()) {
            Namespace ns = iter.next();
            if (ns.isDefaultNamespaceDeclaration() || mappings.containsKey(ns.getNamespaceURI())) continue;
            list.add(ns);
        }
        return Collections.unmodifiableList(list).iterator();
    }

    private static XMLInputFactory getXmlInputFactory() {
        if (XIF == null) {
            try {
                XIF = XMLHelper.newXMLInputFactory();
            }
            catch (Exception e) {
                LOGGER.error("Issue creating XMLInputFactory", e);
                throw e;
            }
        }
        return XIF;
    }

    private static XMLOutputFactory getXmlOutputFactory() {
        if (XOF == null) {
            try {
                XOF = XMLHelper.newXMLOutputFactory();
            }
            catch (Exception e) {
                LOGGER.error("Issue creating XMLOutputFactory", e);
                throw e;
            }
        }
        return XOF;
    }

    private static XMLEventFactory getXmlEventFactory() {
        if (XEF == null) {
            try {
                XEF = XMLHelper.newXMLEventFactory();
            }
            catch (Exception e) {
                LOGGER.error("Issue creating XMLEventFactory", e);
                throw e;
            }
        }
        return XEF;
    }
}

