/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.ddf;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherBlipRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherContainerRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherRecordFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherRecordTypes;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.UnknownEscherRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.BitField;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.BitFieldFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndian;
import java.util.function.Supplier;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static final BitField IS_CONTAINER = BitFieldFactory.getInstance(15);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        short options = LittleEndian.getShort(data, offset);
        short recordId = LittleEndian.getShort(data, offset + 2);
        EscherRecord escherRecord = this.getConstructor(options, recordId).get();
        escherRecord.setRecordId(recordId);
        escherRecord.setOptions(options);
        return escherRecord;
    }

    protected Supplier<? extends EscherRecord> getConstructor(short options, short recordId) {
        EscherRecordTypes recordTypes = EscherRecordTypes.forTypeID(recordId);
        if (recordTypes == EscherRecordTypes.UNKNOWN && IS_CONTAINER.isAllSet(options)) {
            return EscherContainerRecord::new;
        }
        if (recordTypes.constructor != null && recordTypes != EscherRecordTypes.UNKNOWN) {
            return recordTypes.constructor;
        }
        if (EscherBlipRecord.RECORD_ID_START <= recordId && recordId <= EscherBlipRecord.RECORD_ID_END) {
            return EscherBlipRecord::new;
        }
        return UnknownEscherRecord::new;
    }
}

