/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.cont;

import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.Record;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import java.io.IOException;

public abstract class ContinuableRecord
extends Record {
    protected ContinuableRecord() {
    }

    protected ContinuableRecord(ContinuableRecord other) {
        super(other);
    }

    protected abstract void serialize(ContinuableRecordOutput var1);

    @Override
    public final int getRecordSize() {
        ContinuableRecordOutput out = ContinuableRecordOutput.createForCountingOnly();
        this.serialize(out);
        out.terminate();
        return out.getTotalSize();
    }

    @Override
    public final int serialize(int offset, byte[] data) {
        int totalSize = 0;
        try (LittleEndianByteArrayOutputStream leo = new LittleEndianByteArrayOutputStream(data, offset);){
            ContinuableRecordOutput out = new ContinuableRecordOutput(leo, this.getSid());
            this.serialize(out);
            out.terminate();
            totalSize = out.getTotalSize();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return totalSize;
    }
}

