/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.internal;

import com.dataiku.dss.shadelibpoi.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import com.dataiku.dss.shadelibpoi.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.Logger;
import com.dataiku.dss.shadelibpoi.org.apache.poi.logging.PoiLogManager;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.OPCPackage;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.StreamHelper;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.internal.ContentTypeManager;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;

public class ZipContentTypeManager
extends ContentTypeManager {
    private static final Logger LOG = PoiLogManager.getLogger(ZipContentTypeManager.class);

    public ZipContentTypeManager(InputStream in, OPCPackage pkg) throws InvalidFormatException {
        super(in, pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveImpl(Document content, OutputStream out) {
        boolean bl;
        ZipArchiveOutputStream zos = out instanceof ZipArchiveOutputStream ? (ZipArchiveOutputStream)out : new ZipArchiveOutputStream(out);
        ZipArchiveEntry partEntry = new ZipArchiveEntry("[Content_Types].xml");
        ZipHelper.adjustEntryTime(partEntry);
        zos.putArchiveEntry(partEntry);
        try {
            bl = StreamHelper.saveXmlInStream(content, zos);
        }
        catch (Throwable throwable) {
            try {
                zos.closeArchiveEntry();
                throw throwable;
            }
            catch (IOException ioe) {
                LOG.atError().withThrowable(ioe).log("Cannot write: [Content_Types].xml in Zip !");
                return false;
            }
        }
        zos.closeArchiveEntry();
        return bl;
    }
}

