/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.forked;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.EvaluationCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.EvaluationWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.IStabilityClassifier;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.WorkbookEvaluator;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.BoolEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ErrorEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.NumberEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.StringEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ValueEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.udf.UDFFinder;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import java.util.stream.Stream;

public final class ForkedEvaluator {
    private final WorkbookEvaluator _evaluator;
    private final ForkedEvaluationWorkbook _sewb;

    private ForkedEvaluator(EvaluationWorkbook masterWorkbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this._sewb = new ForkedEvaluationWorkbook(masterWorkbook);
        this._evaluator = new WorkbookEvaluator(this._sewb, stabilityClassifier, udfFinder);
    }

    public static ForkedEvaluator create(Workbook wb, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new ForkedEvaluator(wb.createEvaluationWorkbook(), stabilityClassifier, udfFinder);
    }

    public void updateCell(String sheetName, int rowIndex, int columnIndex, ValueEval value) {
        ForkedEvaluationCell cell = this._sewb.getOrCreateUpdatableCell(sheetName, rowIndex, columnIndex);
        cell.setValue(value);
        this._evaluator.notifyUpdateCell(cell);
    }

    public void copyUpdatedCells(Workbook workbook) {
        this._sewb.copyUpdatedCells(workbook);
    }

    public ValueEval evaluate(String sheetName, int rowIndex, int columnIndex) {
        EvaluationCell cell = this._sewb.getEvaluationCell(sheetName, rowIndex, columnIndex);
        switch (cell.getCellType()) {
            case BOOLEAN: {
                return BoolEval.valueOf(cell.getBooleanCellValue());
            }
            case ERROR: {
                return ErrorEval.valueOf(cell.getErrorCellValue());
            }
            case FORMULA: {
                return this._evaluator.evaluate(cell);
            }
            case NUMERIC: {
                return new NumberEval(cell.getNumericCellValue());
            }
            case STRING: {
                return new StringEval(cell.getStringCellValue());
            }
            case BLANK: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + (Object)((Object)cell.getCellType()) + ")");
    }

    public static void setupEnvironment(String[] workbookNames, ForkedEvaluator[] evaluators) {
        WorkbookEvaluator[] wbEvals = (WorkbookEvaluator[])Stream.of(evaluators).map(e -> e._evaluator).toArray(WorkbookEvaluator[]::new);
        CollaboratingWorkbooksEnvironment.setup(workbookNames, wbEvals);
    }
}

