/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.GlobalUsageSummaryBuilder;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.activity.filterutils.FilterAnalyzer;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightParams;
import com.dataiku.dip.dashboards.insights.chart.DatasetSourceParams;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.dataquality.DataQualityTemplate;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.metrics.checks.CustomPythonCheck;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartType;
import com.dataiku.dip.pivot.frontend.model.ChartVariant;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.ScriptUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDesc;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfRule;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableSet;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSPredictionEndpointConfigBase;
import com.dataiku.lambda.model.studioconfig.DSSPredictionFeaturesLeftJoinMapping;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.refine.udaf.UdafUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UsageSummaryBuilderUtils {
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private InsightsDAO insightsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    public UsageSummaryBuilderUtils() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void summarizeDataset(UsageSummaryModel.DatasetsSummaryReport ret, String projectKey, SerializedDataset sd, Set<String> inputObjects, Set<String> outputObjects) {
        VariablesExpansionLoopConfig config;
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, sd.name);
        ++ret.all;
        UsageSummaryBuilderUtils.inc(ret.allByType, sd.type);
        if (sd.managed) {
            ++ret.managed;
            UsageSummaryBuilderUtils.inc(ret.managedByType, sd.type);
        }
        if ((config = DatasetUtils.getDatasetVeLoopConfig(sd.getParams())) != null && config.isEnabled()) {
            UsageSummaryBuilderUtils.inc(ret.repeatingByType, sd.type);
        }
        if (inputObjects.contains(sd.name) && outputObjects.contains(loc.getFullName())) {
            UsageSummaryBuilderUtils.inc(ret.flowIO, sd.type);
        } else if (inputObjects.contains(loc.getFullName())) {
            UsageSummaryBuilderUtils.inc(ret.flowInput, sd.type);
        } else if (outputObjects.contains(loc.getFullName())) {
            UsageSummaryBuilderUtils.inc(ret.flowOutput, sd.type);
        } else {
            UsageSummaryBuilderUtils.inc(ret.notFlow, sd.type);
        }
        if (sd.partitioning != null && sd.partitioning.getDimensionNames().size() > 0) {
            this.incl(ret.partitionedByType, sd.type, 1L);
        }
        try {
            DataQualityRuleSet ruleSet = sd.getDataQualityRuleSet();
            if (ruleSet.monitor) {
                ++ret.monitored;
            }
            if (!ruleSet.getRules().isEmpty()) {
                ++ret.withDataQualityRules;
            }
        }
        catch (Exception e) {
            logger.warnV("Failed to read rules config on dataset %s: %s", new Object[]{sd.getId(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    public void summarizeRules(UsageSummaryModel.DataQualitySummaryReport ret, SerializedDataset sd) {
        try {
            DataQualityRuleSet ruleSet = sd.getDataQualityRuleSet();
            for (DataQualityRule r : ruleSet.getRules()) {
                String type = r instanceof CustomPythonCheck ? "plugin" : r.type;
                ++ret.all;
                UsageSummaryBuilderUtils.inc(ret.byType, type);
            }
        }
        catch (Exception e) {
            logger.warnV("Failed to read detailed type of rules on dataset %s: %s", new Object[]{sd.getId(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    public void summarizeDataQualityTemplate(UsageSummaryModel.DataQualityTemplatesSummaryReport ret, DataQualityTemplate tpl) {
        try {
            ++ret.templateCount;
            for (DataQualityRule r : tpl.getRules()) {
                String type = r instanceof CustomPythonCheck ? "plugin" : r.type;
                ++ret.totalRuleCount;
                UsageSummaryBuilderUtils.inc(ret.ruleCountByType, type);
            }
        }
        catch (Exception e) {
            logger.warnV("Failed to read rule template %s: %s", new Object[]{tpl.getId(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    public void summarizeStreamingEndpoint(UsageSummaryModel.StreamingEndpointsSummaryReport ret, String projectKey, StreamingEndpoint se, Set<String> inputDatasets, Set<String> outputDatasets) {
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, se.id);
        ++ret.all;
        UsageSummaryBuilderUtils.inc(ret.allByType, se.type);
        if (inputDatasets.contains(se.id) && outputDatasets.contains(loc.getFullName())) {
            UsageSummaryBuilderUtils.inc(ret.flowIO, se.type);
        } else if (inputDatasets.contains(loc.getFullName())) {
            UsageSummaryBuilderUtils.inc(ret.flowInput, se.type);
        } else if (outputDatasets.contains(loc.getFullName())) {
            UsageSummaryBuilderUtils.inc(ret.flowOutput, se.type);
        } else {
            UsageSummaryBuilderUtils.inc(ret.notFlow, se.type);
        }
    }

    public static void inc(Map<String, Integer> countMap, String key) {
        Integer prev;
        if (key == null) {
            key = "null";
        }
        if ((prev = countMap.get(key)) == null) {
            prev = 0;
        }
        countMap.put(key, prev + 1);
    }

    public static void iinc(Map<Integer, Integer> countMap, int key) {
        Integer prev = countMap.get(key);
        if (prev == null) {
            prev = 0;
        }
        countMap.put(key, prev + 1);
    }

    public void incl(Map<String, Long> countMap, String key, long increment) {
        Long prev = countMap.get(key);
        if (prev == null) {
            prev = 0L;
        }
        countMap.put(key, prev + increment);
    }

    public static void mergeCountMap(Map<String, Integer> to, Map<String, Integer> from) {
        for (Map.Entry<String, Integer> fk : from.entrySet()) {
            if (!to.containsKey(fk.getKey())) {
                to.put(fk.getKey(), 0);
            }
            to.put(fk.getKey(), to.get(fk.getKey()) + fk.getValue());
        }
    }

    public JsonObject shakerDetails(UsageSummaryModel.ShakerRecipesProjectReport section, SerializedShakerScript sss) {
        JsonObject obj = new JsonObject();
        JsonArray steps = new JsonArray();
        obj.add("steps", (JsonElement)steps);
        for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(sss.steps)) {
            UsageSummaryBuilderUtils.inc(section.processorsByType, step.type);
            steps.add((JsonElement)BaseProcessorsFactory.getReport(step));
        }
        return obj;
    }

    public JsonObject shakerDetails(UsageSummaryModel.AnalysisProjectReport section, SerializedShakerScript sss) {
        JsonObject obj = new JsonObject();
        JsonArray steps = new JsonArray();
        obj.add("steps", (JsonElement)steps);
        for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(sss.steps)) {
            UsageSummaryBuilderUtils.inc(section.processorsByType, step.type);
            steps.add((JsonElement)BaseProcessorsFactory.getReport(step));
        }
        return obj;
    }

    public void summarizeScenario(UsageSummaryModel.ScenariosSummaryReport ret, Scenario sc) {
        ++ret.all;
        if (sc.triggers.size() > 0) {
            ++ret.withTriggers;
        }
        if (sc.isActive()) {
            ++ret.active;
            if (sc.triggers.size() > 0) {
                ++ret.activeWithTriggers;
            }
        }
        if (sc.markedAsTest) {
            ++ret.markedAsTest;
        }
        UsageSummaryBuilderUtils.inc(ret.scenarioByType, sc.getType());
        if (sc.getParams() instanceof StepBasedScenarioRunner.StepBasedScenarioParams) {
            for (Step step : sc.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class).steps) {
                UsageSummaryBuilderUtils.inc(ret.stepByType, step.getType());
                if (!sc.markedAsTest) continue;
                UsageSummaryBuilderUtils.inc(ret.stepByTypeInTestScenario, step.getType());
            }
        }
        for (Trigger trigger : sc.getTriggers()) {
            UsageSummaryBuilderUtils.inc(ret.triggerByType, trigger.getType());
        }
        for (ScenarioReporter reporter : sc.getReporters()) {
            if (reporter.getMessaging() == null) continue;
            UsageSummaryBuilderUtils.inc(ret.reporterByType, reporter.getMessaging().getType());
        }
    }

    public void summarizeAPIService(UsageSummaryModel.APIServicesSummaryReport ret, LambdaService lsc) {
        ++ret.services;
        UsageSummaryBuilderUtils.inc(ret.servicesByAuthorizationMethod, lsc.authMethod == null ? "unknown" : lsc.authMethod.name());
        boolean serviceWithOpenAPI = false;
        for (DSSLambdaEndpointConfig endpoint : lsc.endpoints) {
            ++ret.endpoints;
            String endpointType = endpoint.type == null ? "unknown" : endpoint.type.toString();
            UsageSummaryBuilderUtils.inc(ret.endpointsByType, endpointType);
            if (endpoint.openAPI != null && endpoint.openAPI.enabled) {
                if (endpoint.openAPI.isManual) {
                    UsageSummaryBuilderUtils.inc(ret.manualOpenAPIByType, endpointType);
                } else {
                    UsageSummaryBuilderUtils.inc(ret.autoOpenAPIByType, endpointType);
                }
                serviceWithOpenAPI = true;
            }
            if (!(endpoint instanceof DSSPredictionEndpointConfigBase)) continue;
            DSSPredictionEndpointConfigBase pendpoint = (DSSPredictionEndpointConfigBase)endpoint;
            if (pendpoint.enrichMapping.size() > 0) {
                ++ret.endpointsWithEnrich;
            }
            for (DSSPredictionFeaturesLeftJoinMapping mapping : pendpoint.enrichMapping) {
                UsageSummaryBuilderUtils.inc(ret.datasetResourcesByType, mapping.packagingType == null ? "unknown" : mapping.packagingType.toString());
            }
        }
        if (serviceWithOpenAPI) {
            ++ret.servicesWithOpenAPI;
        }
    }

    UsageSummaryModel.ChartsProjectReport buildSummarizedProjectChartsSection(String projectKey) {
        UsageSummaryModel.ChartsProjectReport section = new UsageSummaryModel.ChartsProjectReport();
        this.buildSummarizedProjectChartsSection(section, projectKey, IndexableType.ANALYSIS);
        this.buildSummarizedProjectChartsSection(section, projectKey, IndexableType.DATASET);
        this.buildSummarizedProjectChartsSection(section, projectKey, IndexableType.INSIGHT);
        return section;
    }

    void summarizeGlobalChartsUsage(UsageSummaryModel.ChartsSummaryReport chartsGlobalReport, UsageSummaryModel.ChartsSummaryReport chartsProjectReport, String projectKey) {
        this.summarizeGlobalChartsUsage(chartsGlobalReport, chartsProjectReport, projectKey, IndexableType.ANALYSIS);
        this.summarizeGlobalChartsUsage(chartsGlobalReport, chartsProjectReport, projectKey, IndexableType.DATASET);
        this.summarizeGlobalChartsUsage(chartsGlobalReport, chartsProjectReport, projectKey, IndexableType.INSIGHT);
    }

    private void buildSummarizedProjectChartsSection(UsageSummaryModel.ChartsProjectReport section, String projectKey, IndexableType chartSource) {
        ChartsInfos chartsInfos = this.getChartInfos(projectKey, chartSource);
        for (ChartDef chartDef : chartsInfos.charts) {
            try {
                JsonObject details = new JsonObject();
                details.addProperty("chartSrc", chartSource.index());
                this.fillChartSection(section, chartSource, chartDef, details);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to summarize chart usage of " + projectKey + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        chartsInfos.countPerEngine.forEach((key, value) -> section.countPerEngine.merge(key, value, Integer::sum));
        section.nbUDAFs += chartsInfos.nbOfCustomMeasures;
        section.nbReusableDimensions += chartsInfos.nbOfReusableDimensions;
        section.nbOfReferenceLines += chartsInfos.nbOfReferenceLines;
    }

    private void fillChartSection(UsageSummaryModel.ChartsSummaryReport section, IndexableType chartSource, ChartDef chartDef, @Nullable JsonObject details) {
        UsageSummaryModel.ChartAxesSummaryReport axesDetailsForChart = this.buildChartAxesSummaryReport(chartDef);
        ++section.nbCharts;
        if (UdafUtils.hasCustomMeasures(chartDef)) {
            ++section.nbChartsWithUDAF;
        }
        if (UsageSummaryBuilderUtils.hasReusableDimensions(chartDef)) {
            ++section.nbChartsWithReusableDimensions;
        }
        if (chartDef.scatterOptions != null && chartDef.scatterOptions.connectPoints != null && chartDef.scatterOptions.connectPoints.enabled || chartDef.scatterMPOptions != null && chartDef.scatterMPOptions.connectPoints != null && chartDef.scatterMPOptions.connectPoints.enabled) {
            UsageSummaryBuilderUtils.inc(section.countConnectPoints, Objects.toString((Object)chartDef.type));
        }
        UsageSummaryBuilderUtils.inc(section.countPerOrigin, chartSource.index());
        UsageSummaryBuilderUtils.inc(section.countPerType, Objects.toString((Object)chartDef.type));
        section.axesDetails.merge(axesDetailsForChart);
        if (details != null && section instanceof UsageSummaryModel.ChartsProjectReport) {
            this.fillChartDetails(details, chartDef, axesDetailsForChart.computeTotalNumberOfDimension());
            ((UsageSummaryModel.ChartsProjectReport)section).details.add(details);
        }
    }

    private void fillChartSection(UsageSummaryModel.ChartsSummaryReport section, IndexableType chartSource, ChartDef chartDef) {
        this.fillChartSection(section, chartSource, chartDef, null);
    }

    private void fillChartDetails(JsonObject details, ChartDef data, int totalNumberOfDimension) {
        if (details != null) {
            details.addProperty("type", Objects.toString((Object)data.type));
            if (CollectionUtils.isNotEmpty(data.filters)) {
                details.addProperty("nfilter", (Number)data.filters.size());
            }
            if (data.type == ChartType.admin_map) {
                details.addProperty("filled", Boolean.valueOf(data.variant == ChartVariant.filled_map));
            }
            if (data.colorOptions.colorPalette != null && !"default".equals(data.colorOptions.colorPalette)) {
                details.addProperty("cpalette", data.colorOptions.colorPalette);
            }
            details.addProperty("ndim", (Number)totalNumberOfDimension);
        }
    }

    private UsageSummaryModel.ChartAxesSummaryReport buildChartAxesSummaryReport(ChartDef data) {
        UsageSummaryModel.ChartAxesSummaryReport result = new UsageSummaryModel.ChartAxesSummaryReport();
        List<DimensionDef> allChartDimensions = Stream.of(data.genericDimension0, data.genericDimension1, data.boxplotBreakdownDim, data.xDimension, data.yDimension, data.groupDimension, data.animationDimension, data.facetDimension).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        allChartDimensions.forEach(result::add);
        if (data.uaXDimension != null) {
            data.uaXDimension.forEach(result::add);
        }
        if (data.uaYDimension != null) {
            data.uaYDimension.forEach(result::add);
        }
        if (data.uaColor != null) {
            data.uaColor.forEach(result::add);
        }
        if (data.uaShape != null) {
            data.uaShape.forEach(result::add);
        }
        if (data.uaSize != null) {
            data.uaSize.forEach(result::add);
        }
        if (data.uaDimensionPair != null) {
            data.uaDimensionPair.forEach(result::add);
        }
        return result;
    }

    private void summarizeGlobalChartsUsage(UsageSummaryModel.ChartsSummaryReport chartsGlobalReport, UsageSummaryModel.ChartsSummaryReport chartsProjectReport, String projectKey, IndexableType chartSource) {
        ChartsInfos chartsInfos = this.getChartInfos(projectKey, chartSource);
        for (ChartDef chartDefinition : chartsInfos.charts) {
            try {
                this.fillChartSection(chartsGlobalReport, chartSource, chartDefinition);
                this.fillChartSection(chartsProjectReport, chartSource, chartDefinition);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to summarize chart usage of " + projectKey + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        chartsInfos.countPerEngine.forEach((key, value) -> chartsGlobalReport.countPerEngine.merge((String)key, (Integer)value, Integer::sum));
        chartsGlobalReport.nbUDAFs += chartsInfos.nbOfCustomMeasures;
        chartsProjectReport.nbUDAFs += chartsInfos.nbOfCustomMeasures;
        chartsGlobalReport.nbReusableDimensions += chartsInfos.nbOfReusableDimensions;
        chartsProjectReport.nbReusableDimensions += chartsInfos.nbOfReusableDimensions;
        chartsGlobalReport.nbOfReferenceLines += chartsInfos.nbOfReferenceLines;
        chartsProjectReport.nbOfReferenceLines += chartsInfos.nbOfReferenceLines;
    }

    private ChartsInfos getChartInfos(String projectKey, IndexableType chartSource) {
        switch (chartSource) {
            case DATASET: {
                return this.getDatasetChartInfos(projectKey);
            }
            case ANALYSIS: {
                return this.getAnalysisChartInfos(projectKey);
            }
            case INSIGHT: {
                return this.getInsightChartInfos(projectKey);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported chart source %s", new Object[]{chartSource}));
    }

    private ChartsInfos getAnalysisChartInfos(String projectKey) {
        ChartsInfos result = new ChartsInfos();
        try {
            for (AnalysisCoreParams.AnalysisListItem ah : this.analysisCRUDService.listHeadsUnsafe(projectKey, null)) {
                try {
                    AnalysisCoreParams acp = this.analysisCRUDService.getCoreOrNullUnsafe(projectKey, ah.id);
                    if (acp == null) continue;
                    result.nbOfCustomMeasures += acp.customMeasures.size();
                    result.nbOfReusableDimensions += acp.reusableDimensions.size();
                    result.nbOfReferenceLines += acp.charts.stream().flatMapToInt(chart -> chart.def.referenceLines != null ? IntStream.of(chart.def.referenceLines.length) : IntStream.empty()).sum();
                    result.charts.addAll(UsageSummaryBuilderUtils.analysisChartToChartDef(acp.charts));
                }
                catch (Exception e) {
                    logger.warnV("Failed to read charts for analyse item %s: %s", new Object[]{ah.id, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to list analysis charts : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return result;
    }

    private ChartsInfos getDatasetChartInfos(String projectKey) {
        ChartsInfos result = new ChartsInfos();
        try {
            for (Map.Entry<String, DatasetExploreSettings> entry : this.exploresService.listExploresForProjectUnsafeWithDatasetName(projectKey).entrySet()) {
                if (entry == null || entry.getValue() == null || entry.getValue().charts == null) continue;
                result.nbOfCustomMeasures += entry.getValue().customMeasures.size();
                result.nbOfReusableDimensions += entry.getValue().reusableDimensions.size();
                result.nbOfReferenceLines += entry.getValue().charts.stream().flatMapToInt(chart -> chart.def.referenceLines != null ? IntStream.of(chart.def.referenceLines.length) : IntStream.empty()).sum();
                ArrayList<ChartDef> charts = new ArrayList<ChartDef>();
                for (DatasetExploreSettings.DatasetChart chart2 : entry.getValue().charts) {
                    if (chart2 == null || chart2.def == null || chart2.def.isNewChartEmpty()) continue;
                    this.addEngineType(projectKey, entry.getKey(), chart2.engineType, result);
                    charts.add(chart2.def);
                }
                result.charts.addAll(charts);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to list analysis charts : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return result;
    }

    private static boolean hasReusableDimensions(ChartDef chartDef) {
        return Stream.of(Optional.ofNullable(chartDef.genericDimension0).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.boxplotBreakdownDim).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.genericDimension1).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.xDimension).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.yDimension).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.groupDimension).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.animationDimension).orElse(Collections.emptyList()), Optional.ofNullable(chartDef.facetDimension).orElse(Collections.emptyList())).flatMap(Collection::stream).anyMatch(dimensionDef -> Boolean.TRUE.equals(dimensionDef.isRBND));
    }

    private ChartsInfos getInsightChartInfos(String projectKey) {
        ChartsInfos result = new ChartsInfos();
        try {
            for (Insight insight : this.insightsDAO.listUnsafe(projectKey)) {
                ChartInsightParams cip;
                if (!"chart".equals(insight.type) || (cip = (ChartInsightParams)insight.params) == null || cip.def == null || cip.def.isNewChartEmpty()) continue;
                result.nbOfCustomMeasures += cip.customMeasures.size();
                result.nbOfReusableDimensions += cip.reusableDimensions.size();
                if (cip.def.referenceLines != null) {
                    result.nbOfReferenceLines += cip.def.referenceLines.length;
                }
                this.addEngineType(projectKey, cip.datasetSmartName, cip.engineType, result);
                result.charts.add(cip.def);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to list analysis charts : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return result;
    }

    private void addEngineType(String projectKey, String datasetName, SerializedShakerScript.ChartsEngine chartsEngine, ChartsInfos chartsInfos) throws IOException {
        SerializedDataset nullUnsafe;
        Object engineType = chartsEngine.toString();
        if (StringUtils.isNotBlank((String)datasetName) && (nullUnsafe = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, datasetName)) != null && DatasetInspector.isSQL(nullUnsafe)) {
            engineType = (String)engineType + "_" + nullUnsafe.type;
        }
        UsageSummaryBuilderUtils.inc(chartsInfos.countPerEngine, (String)engineType);
    }

    private static List<ChartDef> analysisChartToChartDef(List<AnalysisCoreParams.AnalysisChart> charts) {
        return charts.stream().map(chart -> chart.def).filter(Objects::nonNull).filter(def -> !def.isNewChartEmpty()).collect(Collectors.toList());
    }

    public void summarizeInsights(Insight insight, Set<String> dashboardInsights, List<UsageSummaryModel.InsightsSummaryReport> reports) {
        reports.forEach(report -> {
            ++report.nbInsights;
            if (!dashboardInsights.contains(insight.id)) {
                ++report.nbInsightsNotPublished;
            }
            UsageSummaryBuilderUtils.inc(report.countByType, insight.type);
        });
    }

    public void summarizeDashboards(Dashboard dashboard, List<UsageSummaryModel.DashboardsSummaryReport> reports, String projectkey, Set<String> dashboardInsights) {
        reports.forEach(report -> {
            ++report.nbDashboards;
            report.nbSlides += dashboard.pages.size();
            if (report.stats.pages == null) {
                report.stats.pages = new UsageSummaryModel.SimpleStats();
            }
            report.stats.pages.addValue(dashboard.pages.size());
            if (dashboard.pages.stream().anyMatch(page -> !page.grid.tiles.isEmpty())) {
                ++report.nbNonEmptyDashboards;
            } else {
                ++report.nbEmptyDashboards;
            }
            if (dashboard.listed) {
                ++report.nbPublic;
            }
            if (dashboard.autoStackUp) {
                ++report.nbDashboardsWithAutoStackUpEnabled;
            }
        });
        for (DashboardPage page : dashboard.pages) {
            HashMap<String, Integer> countByType = new HashMap<String, Integer>();
            int nbChildTilesInGroupTiles = 0;
            HashSet datasetSources = new HashSet();
            LinkedList<Tile> tiles = new LinkedList<Tile>(page.grid.tiles);
            while (!tiles.isEmpty()) {
                Tile tile = tiles.pop();
                dashboardInsights.add(tile.insightId);
                String tileType = tile.insightType == null ? (tile.tileType == null ? "unknown" : tile.tileType.name().toLowerCase()) : tile.insightType;
                countByType.put(tileType, countByType.getOrDefault(tileType, 0) + 1);
                if (Tile.TileType.GROUP.equals((Object)tile.tileType) && tile.grid != null && tile.grid.tiles != null) {
                    tiles.addAll(tile.grid.tiles);
                    nbChildTilesInGroupTiles += tile.grid.tiles.size();
                    continue;
                }
                if (!ImmutableSet.of((Object)"dataset_table", (Object)"chart", (Object)"filters").contains((Object)tileType)) continue;
                try {
                    Insight insightFound = (Insight)this.insightsDAO.getOrNullUnsafe(projectkey, tile.insightId);
                    Optional.ofNullable(insightFound).ifPresent(insight -> datasetSources.add(insight.getParamsAs(DatasetSourceParams.class).datasetSmartName));
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to summarize insight " + tile.insightId + " of dashboard " + dashboard.id + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            int finalNbChildTilesInGroupTiles = nbChildTilesInGroupTiles;
            String groupTileTypeKey = Tile.TileType.GROUP.name().toLowerCase();
            countByType.forEach((key, count) -> reports.forEach(report -> {
                if (groupTileTypeKey.equals(key)) {
                    this.updateGroupTileSummaryReport((UsageSummaryModel.DashboardsSummaryReport)report, groupTileTypeKey, (int)count, finalNbChildTilesInGroupTiles);
                } else {
                    this.updateTilesSummaryReport((UsageSummaryModel.DashboardsSummaryReport)report, (String)key, (int)count);
                }
            }));
            if (datasetSources.isEmpty()) continue;
            reports.forEach(report -> {
                if (report.stats.datasetSourcesPerPage == null) {
                    report.stats.datasetSourcesPerPage = new UsageSummaryModel.SimpleStats();
                }
                report.stats.datasetSourcesPerPage.addValue(datasetSources.size());
            });
        }
    }

    public void updateGroupTileSummaryReport(UsageSummaryModel.DashboardsSummaryReport report, String groupTileTypeKey, int count, int numberOfChildTiles) {
        UsageSummaryModel.GroupTilesSummaryReport groupTileSummary = (UsageSummaryModel.GroupTilesSummaryReport)report.tiles.getOrDefault(groupTileTypeKey, new UsageSummaryModel.GroupTilesSummaryReport());
        groupTileSummary.nbChildTiles += numberOfChildTiles;
        this.updateTilesSummaryProperties(groupTileSummary, count);
        report.tiles.put(groupTileTypeKey, groupTileSummary);
    }

    public void updateTilesSummaryProperties(UsageSummaryModel.TilesSummaryReport tileSummary, int count) {
        tileSummary.total += count;
        tileSummary.maxByPage = Math.max(tileSummary.maxByPage, count);
    }

    public void updateTilesSummaryReport(UsageSummaryModel.DashboardsSummaryReport report, String key, int count) {
        UsageSummaryModel.TilesSummaryReport tileSummary = report.tiles.getOrDefault(key, new UsageSummaryModel.TilesSummaryReport());
        this.updateTilesSummaryProperties(tileSummary, count);
        report.tiles.put(key, tileSummary);
    }

    public void summarizeAppManifest(UsageSummaryModel.AppManifestsSummaryReport ret, AppManifest manifest, GlobalUsageSummaryBuilder.ApplicationInstanceInfoByAppId applicationInstanceInfoByAppId) {
        boolean isUsedAsRecipe;
        ++ret.all;
        UsageSummaryBuilderUtils.iinc(ret.allBySectionCount, manifest.homepageSections.size());
        for (AppManifest.AppHomepageSection section : manifest.homepageSections) {
            for (AppHomepageTile tile : section.tiles) {
                if (tile == null || tile.type == null) continue;
                UsageSummaryBuilderUtils.inc(ret.tileByType, tile.type.name());
                UsageSummaryBuilderUtils.iinc(ret.allByTileCount, 1);
            }
        }
        GlobalUsageSummaryBuilder.ApplicationInstanceType applicationInstanceType = GlobalUsageSummaryBuilder.ApplicationInstanceType.APPLICATION_FROM_PROJECT;
        boolean bl = isUsedAsRecipe = manifest.useAsRecipeSettings != null;
        if (isUsedAsRecipe) {
            ++ret.useAsRecipe;
            applicationInstanceType = GlobalUsageSummaryBuilder.ApplicationInstanceType.APPLICATION_AS_RECIPE_FROM_PROJECT;
        }
        applicationInstanceInfoByAppId.setApplicationInstanceTypeIfExists(manifest.id, applicationInstanceType);
        if (manifest.projectExportManifest.exportAllDatasets || manifest.projectExportManifest.exportAllInputDatasets || manifest.projectExportManifest.exportUploads || manifest.projectExportManifest.exportManagedFS || !manifest.projectExportManifest.includedDatasetsData.isEmpty()) {
            ++ret.includesDatasetData;
        }
        if (manifest.projectExportManifest.exportAllInputManagedFolders || manifest.projectExportManifest.exportManagedFolders || !manifest.projectExportManifest.includedManagedFolders.isEmpty()) {
            ++ret.includesFolderData;
        }
        if (manifest.projectExportManifest.exportSavedModels || manifest.projectExportManifest.exportAnalysisModels || !manifest.projectExportManifest.includedSavedModels.isEmpty()) {
            ++ret.includesModelData;
        }
        if (manifest.limitedVisibilityEnabled.isDisabled()) {
            ++ret.privateAccessibility;
        } else if (manifest.limitedVisibilityEnabled.isEnabled()) {
            ++ret.limitedAccessAccessibility;
        } else if (manifest.limitedVisibilityEnabled.isInherited()) {
            ++ret.inheritedAccessibility;
        }
        if (!manifest.projectExportManifest.includedCodeStudios.isEmpty()) {
            ++ret.includesCodeStudioData;
        }
        if (!manifest.projectExportManifest.includedKnowledgeBanks.isEmpty()) {
            ++ret.includesKnowledgeBankData;
        }
        if (!manifest.projectExportManifest.includedPromptStudiosHistories.isEmpty()) {
            ++ret.includesPromptStudiosHistories;
        }
    }

    public void summarizeWorkspace(UsageSummaryModel.WorkspaceSummaryReport ret, Workspace workspace) {
        ret.objects += workspace.workspaceObjects.size();
        for (Workspace.WorkspaceObject object : workspace.workspaceObjects) {
            UsageSummaryBuilderUtils.inc(ret.objectsByType, object.getType());
        }
        for (BasePermissions.PermissionItem permission : workspace.permissions) {
            String role;
            String string = role = permission.admin ? "ADMIN" : "MEMBER";
            if (permission.user != null) {
                ++ret.users;
                UsageSummaryBuilderUtils.inc(ret.usersByRole, role);
                continue;
            }
            if (permission.group == null) continue;
            ++ret.groups;
            UsageSummaryBuilderUtils.inc(ret.groupsByRole, role);
        }
    }

    private void traverseIfThen(VisualIfRuleAggregator aggregator, VisualIfDesc.IfThen ifThen) {
        ++aggregator.totalNbRules;
        if (ifThen.filter != null) {
            FilterAnalyzer.FilterSummary filterSummary = FilterAnalyzer.analyzeFilter(ifThen.filter);
            aggregator.totalNbConditions += filterSummary.numberOfConditions;
            aggregator.totalDepths += filterSummary.depth;
            aggregator.totalNbGroups += filterSummary.nbGroups;
            if (filterSummary.numberOfConditions > aggregator.maxNbConditions) {
                aggregator.maxNbConditions = filterSummary.numberOfConditions;
            }
            if (filterSummary.depth > aggregator.maxDepth) {
                aggregator.maxDepth = filterSummary.depth;
            }
            if (filterSummary.nbGroups > aggregator.maxNbGroups) {
                aggregator.maxNbGroups = filterSummary.nbGroups;
            }
        }
        if (ifThen.actions != null) {
            int nbActions = (int)ifThen.actions.stream().filter(Objects::nonNull).count();
            aggregator.totalNbThen += nbActions;
            if (nbActions > aggregator.maxNbThen) {
                aggregator.maxNbThen = nbActions;
            }
        }
    }

    private void traverseVisualIfRuleProcessor(VisualIfRuleAggregator aggregator, ProcessorScriptStep step) {
        if ("VisualIfRule".equals(step.type) && step.params instanceof VisualIfRule.Parameter) {
            VisualIfRule.Parameter params = (VisualIfRule.Parameter)step.params;
            if (params.visualIfDesc != null) {
                ++aggregator.nbProcessors;
                int nbRulesInProcessor = 0;
                if (params.visualIfDesc.ifThen != null) {
                    ++nbRulesInProcessor;
                    this.traverseIfThen(aggregator, params.visualIfDesc.ifThen);
                }
                if (params.visualIfDesc.elseIfThens != null) {
                    for (VisualIfDesc.IfThen elseIfThen : params.visualIfDesc.elseIfThens) {
                        if (elseIfThen == null) continue;
                        ++nbRulesInProcessor;
                        this.traverseIfThen(aggregator, elseIfThen);
                    }
                }
                if (nbRulesInProcessor > aggregator.maxNbRules) {
                    aggregator.maxNbRules = nbRulesInProcessor;
                }
                if (params.visualIfDesc.elseActions != null) {
                    int nbElseActions = (int)params.visualIfDesc.elseActions.stream().filter(Objects::nonNull).count();
                    aggregator.totalNbElse += nbElseActions;
                    if (nbElseActions > aggregator.maxNbElse) {
                        aggregator.maxNbElse = nbElseActions;
                    }
                }
            }
        }
    }

    public void gatherVisualIfRules(VisualIfRuleAggregator aggregator, SerializedShakerScript sss) {
        if (sss != null && sss.steps != null) {
            for (ScriptStep step : sss.steps) {
                if (step == null || step.disabled) continue;
                if (step.metaType == ScriptStep.MetaType.PROCESSOR) {
                    this.traverseVisualIfRuleProcessor(aggregator, (ProcessorScriptStep)step);
                    continue;
                }
                if (step.metaType != ScriptStep.MetaType.GROUP) continue;
                for (ProcessorScriptStep pss : ((GroupScriptStep)step).steps) {
                    if (pss.disabled) continue;
                    this.traverseVisualIfRuleProcessor(aggregator, pss);
                }
            }
        }
    }

    private static class ChartsInfos {
        public List<ChartDef> charts = new ArrayList<ChartDef>();
        public Map<String, Integer> countPerEngine = new HashMap<String, Integer>();
        public int nbOfCustomMeasures;
        public int nbOfReusableDimensions;
        public int nbOfReferenceLines;

        private ChartsInfos() {
        }
    }

    public static class VisualIfRuleAggregator {
        public int nbProcessors = 0;
        public int totalNbRules = 0;
        public int maxNbRules = 0;
        public int totalNbConditions = 0;
        public int maxNbConditions = 0;
        public int totalNbGroups = 0;
        public int maxNbGroups = 0;
        public int totalDepths = 0;
        public int maxDepth = 0;
        public int totalNbThen = 0;
        public int maxNbThen = 0;
        public int totalNbElse = 0;
        public int maxNbElse = 0;

        public UsageSummaryModel.VisualIfRuleSummary toSummary() {
            if (this.nbProcessors == 0) {
                return null;
            }
            UsageSummaryModel.VisualIfRuleSummary summary = new UsageSummaryModel.VisualIfRuleSummary();
            summary.nbProcessors = this.nbProcessors;
            summary.avgNumberOfRule = this.nbProcessors > 0 ? (double)this.totalNbRules / (double)this.nbProcessors : 0.0;
            summary.maxNbOfRule = this.maxNbRules;
            summary.avgNbOfConditions = this.totalNbRules > 0 ? (double)this.totalNbConditions / (double)this.totalNbRules : 0.0;
            summary.maxNbOfConditions = this.maxNbConditions;
            summary.avgDepth = this.totalNbRules > 0 ? (double)this.totalDepths / (double)this.totalNbRules : 0.0;
            summary.maxDepth = this.maxDepth;
            summary.avgNbThen = this.totalNbRules > 0 ? (double)this.totalNbThen / (double)this.totalNbRules : 0.0;
            summary.maxNbThen = this.maxNbThen;
            summary.avgNbElse = this.nbProcessors > 0 ? (double)this.totalNbElse / (double)this.nbProcessors : 0.0;
            summary.maxNbElse = this.maxNbElse;
            summary.avNbOfGroups = this.totalNbRules > 0 ? (double)this.totalNbGroups / (double)this.totalNbRules : 0.0;
            summary.maxNbOfGroups = this.maxNbGroups;
            return summary;
        }
    }
}

