/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedAgentsToolsDAO
extends AbstractStandardDAO<AgentTool>
implements AgentToolsDAO {
    @Override
    protected AgentTool getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        AgentTool obj = unsafe ? (AgentTool)tr.readObjectUnsafe(rf, AgentTool.class) : (AgentTool)tr.readObject(rf, AgentTool.class);
        obj.id = id;
        obj.projectKey = projectKey;
        if (obj.type.equals("InlinePython")) {
            obj.params.addProperty("code", this.getPythonToolCode(projectKey, id));
        }
        return obj;
    }

    @Override
    protected List<AgentTool> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile agentToolsFolder = this.agentToolsFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<AgentTool> ret = new ArrayList<AgentTool>();
        if (tr.isDirectory(agentToolsFolder)) {
            for (RelFile f : tr.listFiles(agentToolsFolder, (RelFileFilter)FileFilter.json())) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    AgentTool obj = (AgentTool)this.getMandatory(projectKey, id, unsafe);
                    ret.add(obj);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read knowledge bank file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void save(AgentTool tool) throws IOException {
        if (tool.type.equals("InlinePython")) {
            RWTransactionRef tr = TransactionContext.retrieveWrite();
            RelFile codeFile = this.getPythonToolFile(tool.projectKey, tool.id);
            JsonElement code = tool.params.get("code");
            if (code != null) {
                tr.writeStringUTF8(codeFile, code.getAsString());
                tool.params.remove("code");
                super.save(tool);
                tool.params.addProperty("code", code.getAsString());
            } else {
                super.save(tool);
            }
        } else {
            super.save(tool);
        }
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Tool is not specified");
        return new RelFile(this.agentToolsFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.AGENT_TOOL.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        File agentToolFolder;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile agentToolFile = this.getDAOFile(projectKey, id);
        t.deleteFile(agentToolFile);
        RelFile codeFile = this.getPythonToolFile(projectKey, id);
        if (t.exists(codeFile)) {
            t.deleteFile(codeFile);
        }
        if ((agentToolFolder = this.agentToolBaseFolder(projectKey, id)).exists()) {
            DKUFileUtils.forceDelete((File)agentToolFolder);
        }
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile agentToolsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(agentToolsFolder = this.agentToolsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(agentToolsFolder).size();
    }

    private RelFile agentToolsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "agent-tools"});
    }

    private RelFile getPythonToolFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Agent tool id is not specified");
        return new RelFile(new String[]{"projects", projectKey, "agent-tools", id + ".py"});
    }

    private String getPythonToolCode(String projectKey, String id) throws IOException {
        RelFile pythonFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(pythonFile = this.getPythonToolFile(projectKey, id))) {
            return null;
        }
        return t.readStringUTF8(pythonFile);
    }

    private File agentToolBaseFolder(String projectKey, String id) {
        return ApplicationConfigurator.getFile((String[])new String[]{"agent-tools", projectKey, id});
    }
}

