/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.custom;

import com.dataiku.dip.agents.tools.AbstractPythonAgentToolRunner;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolMeta;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;

public class CustomAgentToolRunner
extends AbstractPythonAgentToolRunner {
    private final CustomAgentToolMeta meta;
    private final CustomAgentToolParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.tools");

    public CustomAgentToolRunner(DSSAuthCtx authCtx, AgentTool at, boolean devKernel, boolean devMode) throws Exception {
        super(authCtx, at);
        this.params = at.getParamsCopyAs(CustomAgentToolParams.class);
        this.devKernel = devKernel;
        this.devMode = devMode;
        this.meta = (CustomAgentToolMeta)AgentToolsRegistry.getMeta(at.type);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        if (this.serverAPI == null) {
            try {
                LoadedCustomAgentTool desc = this.meta.getLoadedDesc();
                String envName = new CodeEnvSelector().selectForCustomPythonRecipe(desc.ownerPluginId);
                String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.projectKey, this.params.containerExecSelection);
                String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.projectKey).getClusterId();
                IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
                File pluginFolder = pluginsService.getActualPluginFolder(desc.ownerPluginId);
                File codeFolder = new File(pluginFolder, desc.folderName);
                CustomAgentToolsService customAgentToolsService = (CustomAgentToolsService)SpringUtils.getBean(CustomAgentToolsService.class);
                String libFolder = customAgentToolsService.getPythonLibFolder(desc.getType());
                String code = DKUFileUtils.readFileToStringUTF8((File)new File(codeFolder, "tool.py"));
                PluginSettingsResolver.ResolvedSettings expandedPluginSettings = customAgentToolsService.getExpandedPluginSettings(desc.getType(), this.authCtx, this.projectKey, this.params.config);
                JsonArray passwordParams = desc.getParams().stream().filter(paramDesc -> paramDesc.type == ParamDesc.Type.PASSWORD).map(paramDesc -> paramDesc.name).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
                expandedPluginSettings.pluginConfig.add("dkuPasswordParams", (JsonElement)passwordParams);
                this.initToolServer(envName, containerConfName, clusterId, libFolder, null, code, desc, expandedPluginSettings, false);
            }
            catch (CustomPythonKernelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize Python Agent Tool", e);
            }
        }
    }

    public static class CustomAgentToolParams
    implements AgentToolParams {
        public JsonObject config = new JsonObject();
        public ContainerExecSelection containerExecSelection = new ContainerExecSelection();
    }
}

