/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AIDistinct
extends AIRecipe {
    public static final String type = "distinct";
    public Params params;

    @Nonnull
    private Dataset getInputFromParamsMandatory(List<Dataset> datasets, String contextProjectKey) {
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        if (dataset == null) {
            throw new IllegalArgumentException("Input dataset not found: " + this.params.input_dataset);
        }
        return dataset;
    }

    private List<String> getValidColumns(Dataset dataset) {
        List datasetSchemaColumns = dataset.getSchema() == null ? Collections.emptyList() : dataset.getSchema().columns;
        Set datasetColumnNames = datasetSchemaColumns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        if (this.params.column_distinct_values == null) {
            return Collections.emptyList();
        }
        return this.params.column_distinct_values.stream().filter(datasetColumnNames::contains).collect(Collectors.toList());
    }

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        if (this.getValidColumns(this.getInputFromParamsMandatory(datasets, contextProjectKey)).isEmpty()) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.DISTINCT.NO_COL_TO_FILTER", "We were unable to determine which column(s) to use to filter duplicate rows", new Object[0])));
        }
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        DistinctRecipePayloadParams recipePayloadParams = new DistinctRecipePayloadParams();
        Dataset dataset = this.getInputFromParamsMandatory(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey);
        List<String> validColumns = this.getValidColumns(dataset);
        recipePayloadParams.globalCount = this.params.compute_count;
        for (String c2 : validColumns) {
            DistinctRecipePayloadParams.GroupingKey key = new DistinctRecipePayloadParams.GroupingKey();
            key.column = c2;
            recipePayloadParams.keys.add(key);
        }
        if (dataset.getSchema() != null && dataset.getSchema().columns.size() == validColumns.size()) {
            recipePayloadParams.selectAllColumns = true;
        }
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)recipePayloadParams);
        return metaCreation;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public Boolean compute_count = false;
        public List<String> column_distinct_values;
    }
}

