/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.helpers;

import com.dataiku.dip.analysis.docgen.model.OriginAnalysisDetails;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DesignDiffCheckUtil {
    private static final String MLTASK_JSON = "mltask.json";

    public static boolean hasOriginalAnalysis(FullModelId fmi) throws IOException {
        OriginAnalysisDetails oad;
        if (fmi.isExternalMLflowModelVersion()) {
            return false;
        }
        try {
            oad = new OriginAnalysisDetails(fmi, fmi.getHeadMLTask());
        }
        catch (IOException e) {
            return false;
        }
        File sessionFile = oad.fmi.getSessionFile(MLTASK_JSON);
        return sessionFile.exists();
    }

    public static boolean hasChangesOccurred(FullModelId fmi) throws IOException {
        OriginAnalysisDetails analysisDetails = new OriginAnalysisDetails(fmi, fmi.getHeadMLTask());
        fmi = analysisDetails.fmi;
        MLTask sessionMltask = fmi.parseSessionFile(MLTASK_JSON, MLTask.class);
        MLTask headMltask = fmi.getHeadMLTask();
        DesignDiffCheckUtil.removeNonDesignRelatedParams(sessionMltask);
        DesignDiffCheckUtil.removeNonDesignRelatedParams(headMltask);
        Gson gson = new Gson();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode o1 = objectMapper.readTree(gson.toJson((Object)sessionMltask));
        JsonNode o2 = objectMapper.readTree(gson.toJson((Object)headMltask));
        return !o1.equals((Object)o2);
    }

    private static void removeNonDesignRelatedParams(MLTask mltask) {
        mltask.predictionDisplayCharts = new ArrayList<MLTask.PredictedDataChart>();
        if (mltask instanceof PredictionMLTask.TabularPredictionMLTask) {
            PredictionModelingParams modeling;
            PredictionMLTask.TabularPredictionMLTask pmlTask = (PredictionMLTask.TabularPredictionMLTask)mltask;
            if (pmlTask.isPartitioned()) {
                pmlTask.partitionedModel.dimensionNames = null;
                pmlTask.partitionedModel.dimensionTypes = null;
            }
            if ((modeling = ((PredictionMLTask.TabularPredictionMLTask)mltask).modeling) != null && modeling.plugin_python != null) {
                HashMap<String, PredictionModelingParams.CustomPythonPluginParams> filteredPlugins = new HashMap<String, PredictionModelingParams.CustomPythonPluginParams>();
                for (Map.Entry<String, PredictionModelingParams.CustomPythonPluginParams> entry : modeling.plugin_python.entrySet()) {
                    if (!entry.getValue().enabled) continue;
                    filteredPlugins.put(entry.getKey(), entry.getValue());
                }
                modeling.plugin_python = filteredPlugins;
            }
        }
    }

    public static boolean hasPlugins(FullModelId fmi) throws IOException {
        OriginAnalysisDetails oad = new OriginAnalysisDetails(fmi, fmi.getHeadMLTask());
        MLTask sessionMltask = oad.fmi.parseSessionFile(MLTASK_JSON, MLTask.class);
        if (sessionMltask instanceof PredictionMLTask.ClassicalPredictionMLTask) {
            PredictionMLTask.ClassicalPredictionMLTask pmlTask = (PredictionMLTask.ClassicalPredictionMLTask)sessionMltask;
            if (pmlTask.modeling != null && pmlTask.modeling.plugin_python != null) {
                for (PredictionModelingParams.CustomPythonPluginParams plugin : pmlTask.modeling.plugin_python.values()) {
                    if (plugin == null || !plugin.enabled) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static InfoMessage getDesignChangedWarningMessage() {
        String errorTitle = "Design has changed since training";
        String errorDetails = "The design placeholders (starting with \"design.\") cannot be resolved because the design settings of the mltask have changed since the model was trained. Revert design to this session\u2019s design to address this warning (See <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://doc.dataiku.com/dss/latest/machine-learning/model-document-generator.html\">the documentation</a> for detailed explanations).";
        return InfoMessage.warning((String)errorTitle, (String)errorDetails);
    }

    public static InfoMessage getAnalysisDeletedWarningMessage() {
        String errorTitle = "There is no visual analysis associated to the current saved model";
        String errorDetails = "The design placeholders (starting with \"design.\") cannot be resolved because the visual analysis was deleted.  (See <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://doc.dataiku.com/dss/latest/machine-learning/model-document-generator.html\">the documentation</a> for detailed explanations).";
        return InfoMessage.warning((String)errorTitle, (String)errorDetails);
    }

    public static InfoMessage getPluginAlgorithmErrorMessage() {
        String errorTitle = "The document model generation is not compatible with plugin algorithms";
        String errorDetails = "You current analysis was generated with at least one plugin algorithm activated. This may result in unexpected behaviour (See <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://doc.dataiku.com/dss/latest/machine-learning/model-document-generator.html\">the documentation</a> for detailed explanations).";
        return InfoMessage.error((String)errorTitle, (String)errorDetails);
    }
}

