/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.PredictedDataService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.pivot.backend.dss.ShakerToLino;
import com.dataiku.dip.pivot.backend.dss.aggregators.LinoColumnFactory;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.analysis.MultiCorrelator;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PredictionPivotTablesService {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.reports");
    TypeInferrer2 typeInferrer = new TypeInferrer2();
    @Autowired
    private PredictedDataService predictedDataService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private LinoUtils linoUtils;
    @Autowired
    private VariablesService variablesService;

    private SerializedShakerScript.RefreshableStreamableSelection chartsSamplingToUse(SerializedShakerScript predictedScript) {
        return predictedScript.getExpandedVizSampling();
    }

    private SerializedShakerScript.ShakerExplorationSampleSettings exploreSamplingToUse(SerializedShakerScript predictedScript) {
        return predictedScript.explorationSampling;
    }

    private File getCacheFolder(FullModelId fmi) throws IOException, NotFoundException {
        File cachesFolder = ApplicationConfigurator.getFile((String)("caches/predicted-charts/" + fmi.toString()));
        MLTask task = fmi.getHeadMLTask();
        return new File(cachesFolder, PredictedDataService.getSampleId(fmi, this.chartsSamplingToUse(task.predictionDisplayScript)));
    }

    public ColumnSummary getColumnSummary_NT(FullModelId fmi) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        MLTask task = fmi.getHeadMLTask();
        ColumnSummary ret = new ColumnSummary();
        ret.requiredSampleId = PredictedDataService.getSampleId(fmi, this.chartsSamplingToUse(task.predictionDisplayScript));
        MemScriptRunner.TableWithReport twr = this.predictedDataService.getUncachedUnfiltered_NOTRANSACTION(fmi, this.exploreSamplingToUse(task.predictionDisplayScript));
        this.linoUtils.fillUsableColumns(twr.table, ret);
        return ret;
    }

    public synchronized LinoColumnFactory getColumnsFactory(FullModelId fmi) throws IOException {
        File cacheFolder = this.getCacheFolder(fmi);
        try (LinoReader cacheReader = LinoUtils.getCachedReader(cacheFolder, null);){
            if (cacheReader != null) {
                LinoColumnFactory linoColumnFactory = new LinoColumnFactory(cacheReader);
                return linoColumnFactory;
            }
        }
        return null;
    }

    public synchronized FutureResponse<Response> getResponse_NT(PivotTableRequest request, FullModelId fmi, AuthCtx user) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)"Lookup cache");
        File cacheFolder = this.getCacheFolder(fmi);
        try (LinoReader cacheReader = LinoUtils.getCachedReader(cacheFolder, request);){
            if (request instanceof PivotTableTensorRequest) {
                for (AxisDef axis : ((PivotTableTensorRequest)request).axes) {
                    Preconditions.checkNotNull((Object)axis);
                }
            }
            FilterUtils.expandRelativeDateFilters(request);
            if (cacheReader != null) {
                logger.info((Object)"Got cache, start execution");
                FutureResponse fr = new FutureResponse();
                fr.hasResult = true;
                fr.result = new Response();
                ((Response)fr.result).updatedSampleId = "anysample";
                ((Response)fr.result).pivotResponse = LinoUtils.fromLino(request, cacheReader, this.variablesService.getContext(fmi.getProjectKey()));
                FutureResponse futureResponse = fr;
                return futureResponse;
            }
            PivotFutureThread ftfd = new PivotFutureThread(fmi, request, (DSSAuthCtx)user);
            FutureResponse<Response> futureResponse = this.futureService.runFuture(ftfd, 2000L, new TypeToken<FutureResponse<Response>>(){});
            return futureResponse;
        }
    }

    public static FuturePayload buildFuturePayload(FullModelId fmi, PivotTableRequest request) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_scatterplot";
        fp.targets.add(DSSFuturePayloadUtils.forFMI(fmi).withPart("prediction_plot"));
        fp.displayName = "Refreshing predicted values plot";
        return fp;
    }

    public static class Response {
        public MultiCorrelator.MultiCorrelation correlationResponse;
        public PivotTableResponse pivotResponse;
        public String updatedSampleId;
    }

    class PivotFutureThread
    extends FutureThread<Response> {
        final FullModelId fmi;
        String usedSampleId;
        final PivotTableRequest request;
        PivotTableResponse response;
        private final FuturePayload futurePayload;

        public PivotFutureThread(FullModelId fmi, PivotTableRequest request, DSSAuthCtx user) {
            super(user);
            this.fmi = fmi;
            this.request = request;
            this.futurePayload = PredictionPivotTablesService.buildFuturePayload(fmi, request);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            MLTask task = this.fmi.getHeadMLTask();
            MemScriptRunner.TableWithReport twr = PredictionPivotTablesService.this.predictedDataService.getUncachedUnfiltered_NOTRANSACTION(this.fmi, PredictionPivotTablesService.this.exploreSamplingToUse(task.predictionDisplayScript));
            Schema schema = TableToSchema.inferSchemaSimple(twr.table, false);
            LinoUtils.checkAllColumns(schema.getColumns(), this.request);
            List<SchemaColumn> linoableColumns = LinoUtils.getLinoableColumns(twr.table);
            if (this.request == null || LinoUtils.allColumnsAreLinoable(linoableColumns, this.request)) {
                logger.info((Object)"Will build and use a cache, computing new hash");
                this.usedSampleId = PredictedDataService.getSampleId(this.fmi, PredictionPivotTablesService.this.chartsSamplingToUse(task.predictionDisplayScript));
                File cacheFolder = PredictionPivotTablesService.this.getCacheFolder(this.fmi);
                DKUFileUtils.mkdirs((File)cacheFolder);
                try (FutureProgress.AutocloseableFutureProgressState buildState = FutureProgress.pushAutoCloseableState((String)"Building cache");){
                    ShakerToLino.fromPredictedMemTable(twr.table, cacheFolder, "cache", linoableColumns, 50000);
                }
                try (LinoReader reader = new LinoReader(cacheFolder, "cache");){
                    this.response = LinoUtils.fromLino(this.request, reader, PredictionPivotTablesService.this.variablesService.getContext(this.fmi.getProjectKey()));
                }
            }
            throw new NotImplementedException();
        }

        public Response getResult() {
            Response r = new Response();
            r.pivotResponse = this.response;
            r.updatedSampleId = this.usedSampleId;
            return r;
        }
    }
}

