/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.analysis.ml.prediction.guess.AnalyseUtils;
import com.dataiku.dip.analysis.ml.prediction.guess.IncrementalFeatureGuessHandler;
import com.dataiku.dip.analysis.ml.shared.Guesser;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PredictionPreprocessingParams;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class PredictionGuesser<T extends PredictionMLTask>
extends Guesser<T> {
    protected List<String> messages = new ArrayList<String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis");

    protected PredictionGuesser(T task, MemTable table) {
        super(task, table);
    }

    public boolean isTargetPresent(String target) {
        return this.table.columns.containsKey(target);
    }

    public boolean canChangePredictionType() {
        return true;
    }

    public void changeTypeNoReguess(PredictionMLTask.PredictionType previousPredictionType, @Nullable GuessStatus previousGuessStatus) {
        this.checkTargetColumn(true);
        this.retrievePreviousGuessStatusBooleans(previousGuessStatus);
        this.checkAllFixableSettings(false);
    }

    public void changeTargetNoReguess(String previousTarget, @Nullable GuessStatus previousGuessStatus) {
        this.checkTargetColumn(true);
        this.retrievePreviousGuessStatusBooleans(previousGuessStatus);
        this.checkAllFixableSettings(false);
        this.guessFeature(((PredictionMLTask)this.task).targetVariable);
        if (!StringUtils.isBlank((String)previousTarget)) {
            this.guessFeature(previousTarget);
        }
    }

    public GuessStatus checkStatus() {
        GuessStatus gs = new GuessStatus();
        if (this.messages.isEmpty()) {
            gs.state = GuessStatus.GuessState.OK;
        } else {
            gs.state = GuessStatus.GuessState.CAN_CHANGE_SETTINGS;
            gs.error = new APIError("Warnings when guessing", String.join((CharSequence)" | ", this.messages) + ".");
        }
        return gs;
    }

    protected void throwOrAddMessage(String message, boolean throwException) {
        if (throwException) {
            throw new IllegalArgumentException(message);
        }
        this.messages.add(message);
    }

    protected void checkTargetColumn(boolean throwException) {
        MemColumn column;
        String targetRoleName;
        String string = targetRoleName = this.task instanceof PredictionMLTask.CausalPredictionMLTask ? "outcome" : "target";
        if (StringUtils.isBlank((String)((PredictionMLTask)this.task).targetVariable)) {
            this.throwOrAddMessage(String.format("No %s variable", targetRoleName), throwException);
        }
        logger.info((Object)("Guessing on MemTable with columns " + StringUtils.join(this.table.columns.values(), (String)",") + " " + targetRoleName + " is " + ((PredictionMLTask)this.task).targetVariable));
        if (!this.isTargetPresent(((PredictionMLTask)this.task).targetVariable)) {
            this.throwOrAddMessage(String.format("Dataset does not contain the %s column '%s'", targetRoleName, ((PredictionMLTask)this.task).targetVariable), throwException);
        }
        if ((column = this.table.columns.get(((PredictionMLTask)this.task).targetVariable)) == null || column.selectedType == null) {
            this.throwOrAddMessage(String.format("Invalid %s variable column: '%s'", targetRoleName, ((PredictionMLTask)this.task).targetVariable), throwException);
        } else {
            int cardinality = AnalyseUtils.getValueFreqs(this.table, column).size();
            if (cardinality < 2) {
                this.throwOrAddMessage(String.format("All values of the %s are equal. Try refreshing the sample.", targetRoleName), throwException);
            }
        }
    }

    protected void checkAllFixableSettings(boolean throwException) {
        this.checkTargetColumn(throwException);
    }

    @Override
    public void updateGuess(@Nullable GuessStatus previousGuessStatus) {
        this.retrievePreviousGuessStatusBooleans(previousGuessStatus);
        this.checkAllFixableSettings(false);
        IncrementalFeatureGuessHandler incremental = new IncrementalFeatureGuessHandler();
        if (((PredictionMLTask)this.task).getPreprocessingParams() != null) {
            incremental.update(this.table, ((PredictionMLTask)this.task).getPreprocessingParams().per_feature, this);
        }
    }

    public void retrievePreviousGuessStatusBooleans(@Nullable GuessStatus previousGuessStatus) {
    }

    public void guessAllSettings(PredictionMLTask.PredictionType enforcedPredictionType, boolean throwException) {
        ((PredictionMLTask)this.task).setPredictionType(enforcedPredictionType);
        this.guessAllSettingsWithFixedPredictionType(throwException);
    }

    @Override
    public void guessAllSettings(boolean throwException) {
        this.guessPredictionType(this.table.columns.get(((PredictionMLTask)this.task).targetVariable));
        this.guessAllSettingsWithFixedPredictionType(throwException);
    }

    protected abstract void guessAllSettingsWithFixedPredictionType(boolean var1);

    protected abstract void guessPredictionType(MemColumn var1);

    protected List<PredictionPreprocessingParams.MappingValue> guessClassificationTargetRemapping(MemTable table, String targetVariable, boolean throwException) {
        MemColumn targetCol = table.column(targetVariable);
        List<AnalyseUtils.TermFreq> freqs = AnalyseUtils.getValueFreqs2(table, targetCol);
        if (throwException && freqs.size() < 2) {
            String targetRoleName = this.task instanceof PredictionMLTask.CausalPredictionMLTask ? "outcome" : "target";
            throw new IllegalArgumentException(String.format("All values of the %s are equal. Try refreshing the sample.", targetRoleName));
        }
        HashSet positives = Sets.newHashSet((Object[])new String[]{"yes", "1", "1.0", "true", "ok"});
        HashSet negatives = Sets.newHashSet((Object[])new String[]{"no", "0", "0.0", "false", "nok"});
        freqs.sort((o1, o2) -> {
            int s2;
            String low1 = o1.val == null ? "null" : o1.val.toLowerCase();
            String low2 = o2.val == null ? "null" : o2.val.toLowerCase();
            int s1 = (positives.contains(low1) ? 1 : 0) - (negatives.contains(low1) ? 1 : 0);
            return s1 > (s2 = (positives.contains(low2) ? 1 : 0) - (negatives.contains(low2) ? 1 : 0)) ? 1 : (s1 < s2 ? -1 : -Integer.compare(o1.freq, o2.freq));
        });
        ArrayList<PredictionPreprocessingParams.MappingValue> targetRemapping = new ArrayList<PredictionPreprocessingParams.MappingValue>();
        for (int i = 0; i < freqs.size(); ++i) {
            AnalyseUtils.TermFreq tf = freqs.get(i);
            targetRemapping.add(new PredictionPreprocessingParams.MappingValue(tf.val, i, tf.freq));
        }
        return targetRemapping;
    }

    protected void guessFeature(String columnName) {
        logger.debug((Object)("Guessing feature " + columnName));
        MemColumn column = this.table.getColumn(columnName);
        FeaturePreprocessingParams fp = this.guessSingleFeature(column);
        fp.state = new FeaturePreprocessingParams.FeatureState();
        fp.state.recordedMeaning = column.selectedType.type.getClass().getSimpleName();
        ((PredictionMLTask)this.task).getPreprocessingParams().per_feature.put(columnName, fp);
    }
}

