/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.shared;

import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.shared.AnalysisWorkSetPreparator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnalysisRetrainWorkSetPreparator
extends AnalysisWorkSetPreparator {
    public AnalysisRetrainWorkSetPreparator(MLTask.MLTaskType taskType, MLTaskLoc taskLoc, String sessionId, List<SimpleKeyValue> labels) {
        super(taskType, taskLoc, sessionId, labels);
    }

    @Override
    public void prepare(WorkSet ws) throws IOException {
        ArrayList<WorkSet.PreprocessingSet> ppSetsToRemove = new ArrayList<WorkSet.PreprocessingSet>();
        for (int i = 0; i < ws.preprocessingSets.size(); ++i) {
            WorkSet.PreprocessingSet ps2 = ws.preprocessingSets.get(i);
            ps2.preprocessingId = this.getPreprocessingId(i + 1);
            File ppRunFolder = this.preprocessingFolder(ps2);
            ps2.run_folder = ppRunFolder.getAbsolutePath();
            ps2.split_folder = this.splitFolder().getAbsolutePath();
            ArrayList<WorkSet.ModelingSet> modelingSetsToRemove = new ArrayList<WorkSet.ModelingSet>();
            for (int j = 0; j < ps2.modelingSets.size(); ++j) {
                WorkSet.ModelingSet ms = ps2.modelingSets.get(j);
                ms.modelId = "m" + (j + 1);
                ms.fullId = this.fullId(ps2, ms);
                File modelingRunFolder = ms.fullId.getModelFolder();
                ms.run_folder = modelingRunFolder.getAbsolutePath();
                if (modelingRunFolder.exists()) {
                    ms.userMeta = (ModelUserMeta)JSON.parseFile((File)new File(modelingRunFolder, "user_meta.json"), ModelUserMeta.class);
                    continue;
                }
                modelingSetsToRemove.add(ms);
            }
            ps2.modelingSets.removeAll(modelingSetsToRemove);
            if (!ps2.modelingSets.isEmpty()) continue;
            ppSetsToRemove.add(ps2);
        }
        ws.preprocessingSets.removeAll(ppSetsToRemove);
    }
}

